﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Text.RegularExpressions;

namespace App.Utility
{
    /// <summary>
    /// 正規表現一致確認クラス。
    /// </summary>
    static class RegexMatch
    {
        /// <summary>
        /// 正規表現に一致するかを確認。
        /// </summary>
        public static bool Check(string input, string pattern)
        {
            return Check(input, new Regex(pattern));
        }

        /// <summary>
        /// 正規表現に一致するかを確認。
        /// </summary>
        public static bool Check(string input, Regex regex)
        {
            Match match = regex.Match(input);
            return match.Success && match.Length == input.Length;
        }
    }
}
