﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;
using System.Threading;

namespace App.Utility
{
    public static class ProcessUtility
    {
        // 入出力の設定をしつつプロセスを開始
        public static int? ProcessStart(string exe, string argument, DataReceivedEventHandler outputDataRecieved, DataReceivedEventHandler errorDataRecieved, Action<Exception> exceptionHandler)
        {
            DebugConsole.Write("ProcessStart: " + exe + " " + argument);
            var info = new ProcessStartInfo(exe, argument);
            info.CreateNoWindow = true;
            info.UseShellExecute = false;

            if (outputDataRecieved != null)
            {
                info.RedirectStandardOutput = true;
                info.StandardOutputEncoding = Encoding.Default;
            }

            if (errorDataRecieved != null)
            {
                info.RedirectStandardError = true;
                info.StandardErrorEncoding = Encoding.Default;
            }

            Process process = null;

            try
            {
                {
                    process = new Process
                    {
                        StartInfo = info
                    };

                    if (outputDataRecieved != null)
                    {
                        process.OutputDataReceived += outputDataRecieved;
                    }
                    if (errorDataRecieved != null)
                    {
                        process.ErrorDataReceived += errorDataRecieved;
                    }

                    process.Start();
                    if (outputDataRecieved != null)
                    {
                        process.BeginOutputReadLine();
                    }
                    if (errorDataRecieved != null)
                    {
                        process.BeginErrorReadLine();
                    }

                    //process.WaitForExit(); だと Abort されない。詳しい理由は不明
                    while (!process.WaitForExit(10000)) { }
                }

                // エラーや例外が起きたときはログ出力しない
                return process.ExitCode;
            }
            catch (Exception exception)
            {
                if (process != null)
                {
                    try
                    {
                        // プロセスが走っているかもしれないので止める
                        process.Kill();
                    }
                    catch
                    {
                        // 何もしない
                        DebugConsole.WriteLine("Failed to Kill process");
                    }
                }

                if (exceptionHandler != null)
                {
                    exceptionHandler(exception);
                }

                return null;
            }
        }
    }
}
