﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.CodeDom.Compiler;

namespace App.Utility
{
    // 式評価

    // 使い方
    //	bool a = ExpressionEvaluator.Eval("1>2", false);
    //	bool b = ExpressionEvaluator.Eval("3 == 2+1", false);
    //	bool c = ExpressionEvaluator.Eval("4 - 2*2", false);

    //	式の戻り値として bool型 int型を受け付けます。
    //	int型の場合は !=0の比較を返します。
    public static class ExpressionEvaluator
    {
        public enum EvalResult
        {
            Success,					    // 成功
            ReturnValueNotBoolOrIntOrFloat,	// bool型でもint型でもfloat型でもない
            IncorrectExpression,		    // 式が正しくない
        }

        // expression : 式
        // onExceptionAnswer : 式評価に失敗した時の答え
        // isSuccess : 式評価に成功したか？
        public static bool Eval(string expression, bool onExceptionAnswer, out EvalResult evalResult)
        {
            try
            {
                var result = (string)evalObj_.Eval(expression);

                // bool型かどうか
                {
                    bool boolResult;
                    if (bool.TryParse(result, out boolResult))
                    {
                        evalResult = EvalResult.Success;
                        return boolResult;
                    }
                }

                // int型かどうか
                {
                    int intResult;
                    if (int.TryParse(result, out intResult))
                    {
                        evalResult = EvalResult.Success;
                        return intResult != 0;
                    }
                }

                // float型かどうか
                {
                    float floatResult;
                    if (float.TryParse(result, out floatResult))
                    {
                        evalResult = EvalResult.Success;
                        return floatResult != 0;
                    }
                }

                DebugConsole.Write("Eval(" + expression + ")=" + result);

                // bool型でもint型でもない
                evalResult = EvalResult.ReturnValueNotBoolOrIntOrFloat;
                return onExceptionAnswer;
            }
            catch (Exception e)
            {
                DebugConsole.WriteLine("Eval(" + expression + ") :" + e.Message);

                evalResult = EvalResult.IncorrectExpression;
                return onExceptionAnswer;
            }
        }

        static ExpressionEvaluator()
        {
            var provider	= new Microsoft.JScript.JScriptCodeProvider();
            var parameters	= new CompilerParameters()
            {
                GenerateInMemory = true
            };

            var result = provider.CompileAssemblyFromSource(parameters, sourceCode_);
            var type   = result.CompiledAssembly.GetType("Evaluator.Evaluator");

            evalObj_ = Activator.CreateInstance(type);
        }

        private static readonly dynamic evalObj_;

        private const string sourceCode_ = @"
            package Evaluator
            {
                class Evaluator
                {
                    public function Eval(expr : String) : String
                    {
                        return eval(expr);
                    }
                }
            }
        ";
    }
}
