﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using App.Controls;
using App.res;

namespace App.Utility
{
    /// <summary>
    /// ドキュメントIOユーティリティ。
    /// </summary>
    public static class DocumentIOUtility
    {
        //---------------------------------------------------------------------
        /// <summary>
        /// 保存先ディレクトリの確認。
        /// </summary>
        public static bool ConfirmSaveDirectory(ref string directoryPath)
        {
            // 空文字列
            if (directoryPath == string.Empty)
            {
                UIMessageBox.Warning(Strings.IO_SaveDirectorySpecify);
                return false;
            }

            try
            {
                if (!Path.IsPathRooted(directoryPath))
                {
                    UIMessageBox.Warning(Strings.IO_NotPathRooted);
                    return false;
                }
            }
            catch (ArgumentException e)
            {
                // パスに無効な文字が指定されています。
                UIMessageBox.Warning(e.Message);
                return false;
            }

            // 存在するかどうか
            if (!Directory.Exists(directoryPath))
            {
                UIMessageBox.Warning(Strings.IO_SaveDirectoryNotFound);
                return false;
            }

            // パスの末尾を調整
            if (directoryPath.EndsWith("\\") || directoryPath.EndsWith("/"))
            {
                directoryPath = directoryPath.Substring(0, directoryPath.Length - 1);
            }

            return true;
        }
    }
}
