﻿using App.Data;
using App.res;

namespace App.PropertyEdit
{
    /// <summary>
    /// モデルプロパティパネルクラス。
    /// </summary>
    public sealed class BoneVisibilityAnimationPanel : AnimationObjectPropertyPanel
    {
        private PropertyCategoryNode ctgGeneral;
        private PropertyCategoryNode ctgCurveEdit;
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public BoneVisibilityAnimationPanel()
        {
            InitializeCategoryView();

            IsSortByAlphabeticalVisible = true;
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_animation_property_window;
            }
        }

        private void InitializeCategoryView()
        {
            // カテゴリ登録
            var ctgRoot = RegisterCategory(0, Strings.ObjectPropertyPanel_BoneVisibilityAnimation_Root, PropertyPageID.BoneVisibilityAnimationRoot, BoneVisibilityAnimationRootPage.CreateInstance);
                ctgGeneral = RegisterCategory(1, Strings.ObjectPropertyPanel_BoneVisibilityAnimation_General, PropertyPageID.BoneVisibilityAnimationGeneral, BoneVisibilityAnimationGeneralPage.CreateInstance,
                    updateModifiedFunc: () => BoneVisibilityAnimationGeneralPage.IsModified(ActiveTarget));
                ctgCurveEdit = RegisterCategory(1, Strings.ObjectPropertyPanel_BoneVisibilityAnimation_CurveEdit, PropertyPageID.BoneVisibilityAnimationCurveEdit, BoneVisibilityAnimationCurveEditPage.CreateInstance,
                    updateModifiedFunc: () => ActiveTarget?.IsCurvesModified() == true);
            var ctgFileInfo = RegisterCategory(1, Strings.ObjectPropertyPanel_FileInformation, PropertyPageID.FileInformation, FileInformationPage.CreateInstance,
                    updateModifiedFunc: () => FileInformationPage.IsModified(ActiveTarget));
            var ctgOptLog = RegisterCategory(1, Strings.ObjectPropertyPanel_OptimizationLog, PropertyPageID.OptimizationLog, OptimizationLogPage.CreateInstance);
            var ctgUserData = RegisterCategory(1, Strings.ObjectPropertyPanel_UserData, PropertyPageID.UserData, UserDataPage.CreateInstance,
                    updateModifiedFunc: () => UserDataPage.IsModified(ActiveTarget));

            CategoryView.Nodes.Add(ctgRoot);
            {
                ctgRoot.Nodes.Add(ctgGeneral);
                ctgRoot.Nodes.Add(ctgCurveEdit);
                ctgRoot.Nodes.Add(ctgFileInfo);
                ctgRoot.Nodes.Add(ctgOptLog);
                ctgRoot.Nodes.Add(ctgUserData);
            }
            CategoryView.ExpandAll();
        }

        /// <summary>
        /// アクティブターゲット。
        /// </summary>
        private BoneVisibilityAnimation ActiveTarget
        {
            get { return (BoneVisibilityAnimation)base.Targets.Active; }
        }

        public override void SetDefaultCategory()
        {
            CategoryView.SelectedNode = ctgCurveEdit;
        }

    }
}
