﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using App.Data;
using nw.g3d.nw4f_3dif;

namespace App.PropertyEdit
{
    public class SkeletalAnimationCurveTreeNodeInfo : IAnimationCurve
    {
        public bool IsEditable { get; set; }
        public AnimationDocument.NonEditableKind NonEditableKind { get; set; }
        public object NonEditableKindDisplayAux { get; set; }
        public bool IsColorCurve { get { return false; } }
        public int ColorComponentIndex { get { return -1; } }

        private readonly SkeletalAnimation target_;
        private readonly string boneName_;
        private readonly bone_anim_target_targetType targetType_;
        private readonly int componentIndex_;
        //private readonly bool isSingleComponent_;

        public SkeletalAnimationCurveTreeNodeInfo(SkeletalAnimation target, string boneName, bone_anim_target_targetType targetType)
        {
            target_ = target;
            boneName_ = boneName;
            targetType_ = targetType;
            componentIndex_ = (int)targetType;
        }

        public AnimTarget GetAnimTarget(GuiObject editTarget)
        {
            Debug.Assert(editTarget is SkeletalAnimation);
            var animation = (SkeletalAnimation)editTarget;
            var bone = animation.GetBoneAnim(boneName_);
            return bone.GetTarget(targetType_);
        }



        public void UpdateIsModified(GuiObject editTarget)
        {
            var animation = (SkeletalAnimation)editTarget;
            var animTarget = GetAnimTarget(animation);
            var savedAnim = animation.savedBoneAnims.FirstOrDefault(x => x.bone_name == boneName_);
            if (savedAnim!=null)
            {
                var savedTarget = savedAnim.GetTarget(targetType_);
                animation.UpdateIsModifiedAnimTarget(
                    (SkeletalAnimation.BoneAnimTarget)animTarget,
                    (SkeletalAnimation.BoneAnimTarget)savedTarget);
            }
        }

        public AnimTarget CreateAnimTarget(GuiObject editTarget)
        {
            Debug.Assert(false);
            throw new NotImplementedException();
        }

        public AnimTarget CreateTemporaryTarget(GuiObject editTarget)
        {
            var source = (SkeletalAnimation.BoneAnimTarget)GetAnimTarget(editTarget);
            return new SkeletalAnimation.BoneAnimTarget()
            {
                //bone = source.bone_name,
                //parent_name = source.parent_name,
            };
        }

        public void SetAnimTarget(GuiObject editTarget, AnimTarget animTarget)
        {
            var anims = ((SkeletalAnimation)editTarget).BoneAnims;
            var index = anims.FindIndex(x => x.bone_name == boneName_);
            Debug.Assert(index >= 0);
            var targets = anims[index].BoneAnimTargets;
            var tindex = targets.FindIndex(x => x.target == targetType_);
            targets[tindex] = (SkeletalAnimation.BoneAnimTarget)animTarget;
        }

        public float GetDefaultValue(GuiObject editTarget)
        {
            return GetAnimTarget(editTarget).GetBaseValue();
        }

        public void IntermediateFileIndices(SkeletalAnimation target, out int boneIndex, out int curveIndexInBinary)
        {
            boneIndex = 0;
            curveIndexInBinary = 0;
            return;
            /*
            foreach (var anim in target.BoneAnims)
            {
                if (!anim.KeyFrames.Any())
                {
                    continue;
                }

                if (anim.bone_name == boneName_)
                {
                    return;
                }

                switch (anim.ExportType)
                {
                    case CurveExportType.Curve:
                    case CurveExportType.Constant:
                        curveIndexInBinary++;
                        break;
                }
                boneIndex++;

            }
            */
        }



        public List<KeyFrame> KeyFrames
        {
            get
            {
                var animTarget = GetAnimTarget(target_);
                return (animTarget != null) ?
                    animTarget.KeyFrames : new List<KeyFrame>();
            }
        }

        public InterpolationType CurveInterpolationType
        {
            get
            {
                var animTarget = GetAnimTarget(target_);

                return animTarget.CurveInterpolationType;
            }

            set
            {
                ;   // 無視
            }
        }

        public string ParentName{		get { return boneName_;			} }
        public string Name{				get { return "dummy";			} }
        public string FullPath{			get { return string.Format("{0} / {1} / {2}", target_.Name, ParentName, targetType_.ToString());	} }
        public int ComponentIndex{		get { return componentIndex_;   } }
        public bool IsRotate{			get { return false;				} }
        public float? MinClampValue { get { return null; } }
        public float? MaxClampValue { get { return null; } }
        public float? MinFitValue { get { return null; } }
        public float? MaxFitValue { get { return null; } }
        public PrimitiveTypeKind CurvePrimitiveType { get { return PrimitiveTypeKind.Float; } }

        public Color CurveColor
        {
            get
            {
                switch (targetType_)
                {
                    case bone_anim_target_targetType.translate_x:
                    case bone_anim_target_targetType.rotate_x:
                    case bone_anim_target_targetType.scale_x:
                        return CurveView.MakeRGBAColorFromIndex(0);

                    case bone_anim_target_targetType.translate_y:
                    case bone_anim_target_targetType.rotate_y:
                    case bone_anim_target_targetType.scale_y:
                        return CurveView.MakeRGBAColorFromIndex(1);

                    case bone_anim_target_targetType.translate_z:
                    case bone_anim_target_targetType.rotate_z:
                    case bone_anim_target_targetType.scale_z:
                        return CurveView.MakeRGBAColorFromIndex(2);
                }
                return CurveView.MakeColorFromString(target_.Name + ParentName + Name);
            }

        }

        public bool IsSame(IAnimationCurve curve)
        {
            var boneCurve = (SkeletalAnimationCurveTreeNodeInfo)curve;
            return target_ == boneCurve.target_ &&
                boneName_ == boneCurve.boneName_ &&
                targetType_ == boneCurve.targetType_;
        }
    }
}
