﻿using System.Diagnostics;
using App.Data;

namespace App.PropertyEdit
{
    public partial class ProjectFileInformationPage : ObjectPropertyPage
    {
        public ProjectFileInformationPage() :
            base(PropertyPageID.ProjctFileInformation)
        {
            InitializeComponent();
        }

        public override Utility.HelpUtility.PageKey HelpKey
        {
            get
            {
                return Utility.HelpUtility.PageKey.p_project_property_window_a_file_data;
            }
        }

        public static ObjectPropertyPage CreateInstance(object arg)
        {
            return new ProjectFileInformationPage();
        }

        protected override void InitializeFormInternal()
        {
            ;
        }

        protected override void UpdateFormInternal(UpdateFormInfo updateFormInfo)
        {
            Debug.Assert(Targets.Active is ProjectDocument);

            ProjectDocument doc = Targets.Active as ProjectDocument;

            lblFullPath.IsModified = doc.IsFilePathModified();
            ltbFullPath.Text		= doc.FilePath;

            UpdateFileInfo(doc.FileInfo);
        }

        public static bool IsModified(ProjectDocument activeTarget)
        {
            return activeTarget != null && activeTarget.IsFilePathModified();
        }

        private void UpdateFileInfo(FileInfo fileInfo)
        {
            if (fileInfo == null)
            {
                ltbCreateUser.Text		= string.Empty;
                ltbCreateHost.Text		= string.Empty;
                ltbCreateDateTime.Text	= string.Empty;
                ltbCreateTool.Text		= string.Empty;

                ltbModifyUser.Text		= string.Empty;
                ltbModifyHost.Text		= string.Empty;
                ltbModifyDateTime.Text	= string.Empty;
                ltbModifyTool.Text		= string.Empty;
            }
            else
            {
                if (fileInfo.create == null)
                {
                    ltbCreateUser.Text		= string.Empty;
                    ltbCreateHost.Text		= string.Empty;
                    ltbCreateDateTime.Text	= string.Empty;
                    ltbCreateTool.Text		= string.Empty;
                }
                else
                {
                    ltbCreateUser.Text		= fileInfo.create.user;
                    ltbCreateHost.Text		= fileInfo.create.host;
                    ltbCreateDateTime.Text	= fileInfo.create.date_time.ToString();
                    ltbCreateTool.Text		= fileInfo.create.tool_name + "    ver " + fileInfo.create.tool_version;
                }

                if (fileInfo.modify == null)
                {
                    ltbModifyUser.Text		= string.Empty;
                    ltbModifyHost.Text		= string.Empty;
                    ltbModifyDateTime.Text	= string.Empty;
                    ltbModifyTool.Text		= string.Empty;
                }
                else
                {
                    ltbModifyUser.Text		= fileInfo.modify.user;
                    ltbModifyHost.Text		= fileInfo.modify.host;
                    ltbModifyDateTime.Text	= fileInfo.modify.date_time.ToString();
                    ltbModifyTool.Text		= fileInfo.modify.tool_name + "    ver " + fileInfo.modify.tool_version;
                }
            }
        }
    }
}
