﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Globalization;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using App.Data;
using App.Utility;
using App.res;

namespace App.Controls
{
    public partial class EditLabelDialog : OkCancelDialog
    {
        private string initialValue;
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public EditLabelDialog(string id, string ui_label, string label, bool name)
        {
            InitializeComponent();
            //DialogUtility.SetHelp(this, "html/Graphics/3DEditor/html/ui/common/user_data/user_data.html#user_data_dialog");
            if (name)
            {
                lblId.Text = "name :";
            }

            ltbID.Text = id;
            ltb_ui_label.Text = ui_label;
            initialValue = label ?? "";
            tbxLabel.Text = initialValue;
        }

        public string Value
        {
            get
            {
                return tbxLabel.Text;
            }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool OnResultOk()
        {
            if (initialValue == Value)
            {
                // データが変わっていなければキャンセル
                DialogResult = DialogResult.Cancel;
            }
            else if (string.IsNullOrEmpty(Value))
            {
                if (!UIMessageBox.YesNo(Strings.EditLabelDialog_Delete))
                {
                    tbxLabel.Text = initialValue;
                    return false;
                }
            }

            return true;
        }

        private void tbxLabel_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (char) Keys.Enter && ModifierKeys == Keys.None)
            {
                btnOK.PerformClick();
            }
        }
    }
}
