﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;
using App.Controls;
using App.Data;
using App.res;
using App.Utility;
using nw.g3d.iflib;
using nw.g3d.nw4f_3dif;

namespace App.PropertyEdit.ShaderParamControls
{
    public partial class EditRenderInfoColor : EditRenderInfoBase
    {
        public RgbaColor Value
        {
            get{	return cepValue.Color;	}
            set{	cepValue.Color = value;	}
        }

        public ColorEditMode EditMode
        {
            get{	return cepValue.EditMode;	}
            set{
                cepValue.EditMode = value;

                // TODO:サイズ調整
                if (cepValue.EditMode == ColorEditMode.RGBA)
                {
                    cepValue.Height = 112;
                }
                else
                if (cepValue.EditMode == ColorEditMode.RGB)
                {
                    cepValue.Height = 90;
                }
                else
                {
                    Debug.Assert(false);
                }
            }
        }

        public float? minimumValue_ = null;
        public float? MinimumValue
        {
            get
            {
                return minimumValue_;
            }

            set
            {
                minimumValue_ = value;
            }
        }

        public float? maximumValue_ = null;
        public float? MaximumValue
        {
            get
            {
                return maximumValue_;
            }

            set
            {
                maximumValue_ = value;
                cepValue.MaximumValue = maximumValue_.HasValue ? maximumValue_.Value : 1.0f;
                cepValue.IsFreeRange = maximumValue_.HasValue == false;
            }
        }

        public render_info_slotType type;
        public EditRenderInfoColor(render_info_slotType type)
        {
            InitializeComponent();
            this.type = type;
            EditMode = type.count == 3 ? ColorEditMode.RGB : ColorEditMode.RGBA;
            cepValue.ColorPickerText = Strings.ColorPicker;

            cepValue.IsDefaultLinear = ConfigData.ApplicationConfig.Color.GammaCorrection;
            cepValue.Tag = (uint)(1<<0);
        }

        public override bool SetValues(Material material, List<string> values, bool candidateModified, CustomUI customUI, Definition.ShadingModelTable table, Predicate<string> visibleGroups, HashSet<string> visiblePages, bool showId, bool showOriginalLabel, Material.ValueResolvedState valueResolvedState)
        {
            float[] paramArray = values.Select(x => { float result; float.TryParse(x, out result); return result; }).ToArray();

            bool rangeSet = false;
            float min = 0;
            float max = 0;
            float[] defaults = new float[0];
            bool packFromHio = false;

            if (Viewer.Manager.Instance.IsConnected)
            {
                var candidate = material.RenderInfoPackFromHio.FloatItems.FirstOrDefault(x => x.name == ParamName);
                if (candidate != null)
                {
                    if (candidate.hasMinMax)
                    {
                        min = candidate.min;
                        max = candidate.max;
                        rangeSet = true;
                    }
                    defaults = candidate.defaults.ToArray();
                    packFromHio = true;
                }
            }

            if (type != null && !packFromHio)
            {
                if (IfShaderAssignUtility.TryParseFloatRange(type.choice, out min, out max))
                {
                    rangeSet = true;
                }

                defaults = G3dDataParser.Tokenize(type.Default()).Select(x => { float result; float.TryParse(x, out result); return result; }).ToArray();
            }
            lblParameter.BackColor = GetBgColor(candidateModified, packFromHio, rangeSet);

            bool validDefault = defaults.All(x => min <= x && x <= max);

            bool enable = type != null && paramArray.Length == type.count && rangeSet && validDefault;
            this.cepValue.Enabled = enable;
            if (enable)
            {
                Value =
                    (paramArray.Length == 3) ?
                        new RgbaColor(paramArray[0], paramArray[1], paramArray[2], 1.0f) :
                        new RgbaColor(paramArray[0], paramArray[1], paramArray[2], paramArray[3]);
                MinimumValue = min;
                MaximumValue = max;
            }

            return false;
        }

        public void FitRange()
        {
            cepValue.FitRange();
        }

        private void cepValue_SequentialValueChanged(object sender, SequentialValueChangedEventArgs e)
        {
            var args = new RenderInfoValueChangedEventArgs()
            {
                ParamName = ParamName,
                ParamValue = Value.ToArray(cepValue.EditMode == ColorEditMode.RGBA).Select(x => x.ToString()).ToList(),
                SequentialValueChangedEventArgs = e,
                type = render_info_typeType.@float,
            };
            InvokeValueChanged(this, args);
        }

        public override IEnumerable<IHasShaderParameterAnimation> FilterAnimation(IEnumerable<IHasShaderParameterAnimation> animations)
        {
            // ここにはこないはず
            Debug.Assert(false);

            return animations.Where(x => x.IsColorType());
        }
    }
}
