﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using App.Controls;
using App.Data;
using App.ConfigData;
using nw.g3d.iflib;
using nw.g3d.nw4f_3dif;

namespace App.PropertyEdit.ShaderParamControls
{
    public partial class EditAttribute : ShaderParamControl
    {
        public string Value
        {
            get;
            set;
        }

        private readonly attrib_varType attrib_var;

        public EditAttribute(attrib_varType attrib)
        {
            InitializeComponent();

            ParamName = attrib.id;
            attrib_var = attrib;
        }

        public override ParamType ParamType
        {
            get { return ParamType.attrib_var; }
        }

        public const int minTextWidth = 100;
        public const int textMargin = 30;
        public string[] validValues = new string[0];
        public override bool SetValue(Material material, string value, CustomUI customUI, Definition.ShadingModelTable table, Predicate<string> visibleGroups, HashSet<string> visiblePages, bool showId, bool showOriginalLabel)
        {
            Value = value;
            var texts = cbxValue.Items.OfType<UIListControlItem>().Select(x => (string)x.Data).ToArray();
            var validAttribs = material.Referrers.Any() ? IfAttributeAssignUtility.AssignableAttribs(material.Referrers.First().Data, material.Name, attrib_var).ToArray() : new IGrouping<string, vtx_attribType>[] { };
            validValues = validAttribs.Select(x => x.Key).ToArray();

            var presetValues = new string[] { };
            if ((material.OwnerDocument is SeparateMaterial) && !validAttribs.Any())
            {
                var hash = new HashSet<string>(validValues);
                presetValues = ApplicationConfig.Preset.VertexAttributeAssignPresets.Select(x => x.Name).Distinct().Where(x => !hash.Contains(x)).ToArray();
                validValues = validValues.Concat(presetValues).ToArray();
            }

            if (!texts.SequenceEqual(
                validValues.Concat(Enumerable.Repeat(value, 1)).Concat(Enumerable.Repeat("", 1)).Distinct()))
            {
                cbxValue.BeginUpdate();
                cbxValue.Items.Clear();
                HashSet<string> names = new HashSet<string>();
                foreach (var attrib in validAttribs.Select(x => x.First()))
                {
                    names.Add(attrib.name);
                    cbxValue.AddItem(attrib.name, attrib.name);
                }

                foreach (var preset in presetValues)
                {
                    names.Add(preset);
                    cbxValue.AddItem(preset, preset);
                }

                if (Value != string.Empty && !names.Contains(Value))
                {
                    names.Add(Value);
                    cbxValue.AddItem(Value, Value);
                }

                cbxValue.AddItem(res.Strings.ShaderParamControl_NotAssigned, string.Empty);
                cbxValue.EndUpdate();
            }

            cbxValue.SelectedItemData = value;
            using (var g = CreateGraphics())
            {
                int width = Math.Max(
                    minTextWidth,
                    cbxValue.Items.OfType<UIListControlItem>().Max(x => (int)g.MeasureString(x.Text, cbxValue.Font).Width) + textMargin);

                if (cbxValue.Width != width)
                {
                    cbxValue.Width = width;
                    return true;
                }
            }

            return false;
        }

        private void cbxValue_SelectedIndexChanged(object sender, EventArgs e)
        {
            AttributeValueChangedEventArgs args = new AttributeValueChangedEventArgs();
            {
                args.ParamName	= ParamName;
                args.ParamValue	= cbxValue.SelectedItemData;
            }

            InvokeValueChanged(this, args);
        }

        private void cbxValue_CustomDrawItem(object sender, CustomDrawListControlItemEventArgs e)
        {
            if (e.Item != null)
            {
                e.ForeColor = (string)e.Item.Data == string.Empty || validValues.Contains((string)e.Item.Data) ? SystemColors.ControlText : Color.Red;
            }
        }
    }
}
