﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using App.ConfigData;
using App.Data;

namespace App.PropertyEdit
{
    public class BoneVisibilityAnimationCurveTreeNodeInfo : IAnimationCurve
    {
        public bool IsEditable { get; set; }
        public AnimationDocument.NonEditableKind NonEditableKind { get; set; }
        public object NonEditableKindDisplayAux { get; set; }
        public bool IsColorCurve { get { return false; } }
        public int ColorComponentIndex { get { return -1; } }

        public AnimTarget GetAnimTarget(GuiObject editTarget)
        {
            var animation = (BoneVisibilityAnimation)editTarget;
            return animation.BoneVisibilityBoneAnims.FirstOrDefault(x => x.bone_name == boneName_);
        }

        public void UpdateIsModified(GuiObject editTarget)
        {
            var animation = (BoneVisibilityAnimation)editTarget;
            var animTarget = GetAnimTarget(animation);
            var savedTarget = animation.savedBoneVisiblityBoneAnims.FirstOrDefault(x => x.bone_name == boneName_);
            animation.UpdateIsModifiedAnimTarget(
                (BoneVisibilityAnimation.BoneVisibilityBoneAnim)animTarget,
                savedTarget);
        }

        public AnimTarget CreateAnimTarget(GuiObject editTarget)
        {
            Debug.Assert(false);
            throw new NotImplementedException();
        }

        public AnimTarget CreateTemporaryTarget(GuiObject editTarget)
        {
            var source = (BoneVisibilityAnimation.BoneVisibilityBoneAnim)GetAnimTarget(editTarget);
            return new BoneVisibilityAnimation.BoneVisibilityBoneAnim()
            {
                bone_name = source.bone_name,
                parent_name = source.parent_name,
                compress_enable = source.compress_enable,
                binarize_visibility = source.binarize_visibility,
                matrix_index = source.matrix_index,
                rigid_body = source.rigid_body,
            };
        }

        public void SetAnimTarget(GuiObject editTarget, AnimTarget animTarget)
        {
            var anims = ((BoneVisibilityAnimation)editTarget).BoneVisibilityBoneAnims;
            var index = anims.FindIndex(x => x.bone_name == boneName_);
            Debug.Assert(index >= 0);
            anims[index] = (BoneVisibilityAnimation.BoneVisibilityBoneAnim)animTarget;
        }

        public float GetDefaultValue(GuiObject editTarget)
        {
            return GetAnimTarget(editTarget).GetBaseValue();
        }

        public void IntermediateFileIndices(BoneVisibilityAnimation target, out int boneIndex, out int curveIndexInBinary)
        {
            boneIndex = 0;
            curveIndexInBinary = 0;
            foreach (var boneAnim in target.BoneVisibilityBoneAnims)
            {
                if (!boneAnim.KeyFrames.Any() || !boneAnim.binarize_visibility)
                {
                    continue;
                }

                if (boneAnim.bone_name == boneName_)
                {
                    return;
                }

                switch (boneAnim.ExportType)
                {
                    case CurveExportType.Curve:
                    case CurveExportType.Constant:
                        curveIndexInBinary++;
                        break;
                }
                boneIndex++;

            }

            Debug.Assert(false);
        }

        private readonly BoneVisibilityAnimation	target_;
        private readonly string					boneName_;

        public BoneVisibilityAnimationCurveTreeNodeInfo(BoneVisibilityAnimation target, string boneName)
        {
            target_		= target;
            boneName_	= boneName;
        }

        public List<KeyFrame> KeyFrames
        {
            get
            {
                var paramAnim = target_.GetParamAnimFromId(boneName_);
                return
                    paramAnim == null ||
                    (!paramAnim.binarize_visibility && ApplicationConfig.Preset.ShowOnlyBinarizeEnabledBoneVisibilityAnimCurve)
                        ? new List<KeyFrame>()
                        : paramAnim.KeyFrames;
            }
        }

        public InterpolationType CurveInterpolationType
        {
            get
            {
                return InterpolationType.Step;
            }

            set
            {
                ;   // 無視
            }
        }

        public string ParentName{		get { return boneName_;			} }
        public string Name{				get { return "dummy";			} }
        public string FullPath{			get { return string.Format("{0} / {1}", target_.Name, ParentName);	} }
        public int ComponentIndex{		get { return 0;					} }
        public bool IsRotate{			get { return false;				} }
        public float? MinClampValue{	get { return 0.0f;				} }
        public float? MaxClampValue{	get { return 1.0f;				} }
        public float? MinFitValue{		get { return 0.0f;				} }
        public float? MaxFitValue{		get { return 1.0f;				} }
        public PrimitiveTypeKind CurvePrimitiveType { get { return PrimitiveTypeKind.Bool; } }

        public Color CurveColor { get { return CurveView.MakeColorFromString(target_.Name + ParentName); } }
        public bool IsSame(IAnimationCurve curve)
        {
            var boneCurve = (BoneVisibilityAnimationCurveTreeNodeInfo)curve;
            return target_ == boneCurve.target_ &&
                boneName_ == boneCurve.boneName_;
        }
    }
}
