﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Windows.Forms;
using App.Properties;

namespace App
{
    public partial class MainFrame
    {
        private ImageList logImageList_;

        private void InitializeLogList()
        {
            logImageList_ = new ImageList()
            {
                ImageSize			= new Size(16, 16),
                ColorDepth			= ColorDepth.Depth32Bit,
                TransparentColor	= Color.Transparent
            };

            foreach(MessageLog.LogType type in Enum.GetValues(typeof(MessageLog.LogType)))
            {
                logImageList_.Images.Add(type.ToString(), (Image)Resources.ResourceManager.GetObject("Log_" + type.ToString(), Resources.Culture));
            }

            lvwLogList.SmallImageList = logImageList_;
            lvwLogList.HideSelection = true;
            clhLogMessage.Width = lvwLogList.ClientSize.Width - 4;
        }
    }
}
