﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using App.Utility;
using App.res;
using nw.g3d.iflib;

namespace App.Data
{
    public static class MergerUtility
    {
        public enum MergeMode
        {
            Manual,			// マージダイアログを出す
            Auto,			// 自動処理
            AutoWithDialog,	// 必要であればダイアログを出す
        }

        public static T LoadDocument<T>(string srcModelPath) where T : IntermediateFileDocument
        {
            T srcModel = null;
            {
                // マージ元モデルを読み込む
                Document tempDoc = null;
                {
                    bool isSuccess = DocumentManager.Read(new DocumentManager.PathWithName(srcModelPath, null), out tempDoc);
                    Debug.Assert(isSuccess && (tempDoc is T));
                }

                srcModel = tempDoc as T;
            }

            if (srcModel == null)
            {
                throw new Exception(String.Format(Strings.Merge_Load_Error, srcModelPath));
            }

            return srcModel;
        }

        public static T CloneDocument<T>(T srcDoc) where T : IntermediateFileDocument
        {
            // 一旦ファイルにする
            string currentTempFileName = TemporaryFileUtility.MakeTemporaryFileName(".current" + PathUtility.ToIfBinaryName(srcDoc.FileDotExt));
            (new DocumentSaver()).WriteDocument(srcDoc, currentTempFileName, false);

            Document clonedDoc = null;
            {
                bool isSuccess = DocumentManager.Read(new DocumentManager.PathWithName(currentTempFileName, null), out clonedDoc);
                Debug.Assert(isSuccess && (clonedDoc is T));
            }

            if (clonedDoc == null)
            {
                throw new Exception();
            }

            // パス情報を作る
            clonedDoc.FileLocation	= srcDoc.FileLocation;
            clonedDoc.Name			= srcDoc.Name;
            clonedDoc.FileDotExt	= srcDoc.FileDotExt;
            clonedDoc.BaseName		= srcDoc.BaseName;
            clonedDoc.BasePath = srcDoc.BasePath;

            return clonedDoc as T;
        }

        public static void AddOptimizeLog(IntermediateFileDocument doc, object data, string srcPath)
        {
            IfProcessLogUtility.Add(
                doc.process_log_array,
                data,
                "merge",
                srcPath.Replace('\\', '/'),
                string.Empty
            );
        }
    }
}
