﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Windows.Forms;
using App.Win32;

namespace App.Controls
{
    /// <summary>
    /// ＵＩリッチテキストボックスクラス。
    /// </summary>
    public class UIRichTextBox : RichTextBox
    {
        public Point ScrollPos
        {
            get
            {
                var point = new Point {X = 0, Y = 0};
                NativeMethods.SendMessage(Handle, NativeMethods.EM_GETSCROLLPOS, IntPtr.Zero, ref point);
                return point;
            }

            set
            {
                NativeMethods.SendMessage(Handle, NativeMethods.EM_SETSCROLLPOS, IntPtr.Zero, ref value);
            }
        }

#if false
        protected override void WndProc(ref Message m)
        {
            switch (m.Msg)
            {
                case WM.WM_VSCROLL:
                {
DebugConsole.WriteLine("case Win32.WM.WM_VSCROLL:");

                    break;
                }
            }

            base.WndProc(ref m);
        }
#endif
    }
}
