﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Windows.Forms;
using Microsoft.VisualBasic.ApplicationServices;

namespace App
{
    public partial class SplashScreenForm : SplashScreenDisposeForm
    {
        public SplashScreenForm()
        {
            InitializeComponent();

            lblTitle.Font		= new Font("Tahoma", 26, FontStyle.Regular, GraphicsUnit.Point, 0);
            lblVersion.Font		= TheApp.GuiFont;
            lblCopyright.Font	= TheApp.GuiFont;

            lblVersion.Text		= string.Format("Version {0} Build {1}", VersionInformation.Version, VersionInformation.BuildDate);
            lblCopyright.Text	= (new ApplicationBase()).Info.Copyright;
        }

        private void SplashScreenForm_Paint(object sender, PaintEventArgs e)
        {
            using(var pen = new Pen(Color.FromArgb(BackColor.R / 2, BackColor.G / 2, BackColor.B / 2)))
            {
                e.Graphics.DrawRectangle(pen, ClientRectangle.Left, ClientRectangle.Top, ClientRectangle.Width - 1, ClientRectangle.Height - 1);
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            // 始めから Zorderを変えると前面に表示されない。
            // 他のウィンドウが表示されていたら後ろに回す。
            if (Program.TheProgram.OpenForms.Count > 1)
            {
                if (IsHandleCreated)
                {
                    BeginInvoke((Action)(() =>
                        {
                            if (IsHandleCreated)
                            {
                                // Z order だけ変更
                                App.Win32.NativeMethods.SetWindowPos(Handle, new IntPtr(1), 0, 0, 0, 0, App.Win32.NativeMethods.SWP_NOSIZE | App.Win32.NativeMethods.SWP_NOMOVE);
                            }
                        }));
                }
            }
        }
    }

    /// <summary>
    /// デザイナで Dispose が生成されるため、SplashScreenDisposeForm で Dispose をオーバーライドする。
    /// </summary>
    public class SplashScreenDisposeForm : Form
    {
        protected override void Dispose(bool disposing)
        {
            // 起動時に 3DEditor が異常終了する問題に対処
            // 以下を参考にした。
            // http://stackoverflow.com/questions/4544604/vb-net-applicationframework-plus-splashscreen-invalidoperationexception
            Program.TheProgram.SplashScreen = null;
            base.Dispose(disposing);
        }
    }
}
