﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using App.Data;

namespace App.Controls
{
    /// <summary>
    /// シェーダーパラメーターアニメーションの修正選択ダイアログクラス。
    /// </summary>
    public sealed partial class SkeletalAnimBindDialog : OkCancelDialog
    {
        public List<string> Messages = new List<string>();
        public List<Material> Materials = new List<Material>();
        public bool CanFix = false;

        public class ErrorInfo
        {
            public Model model;
            public SkeletalAnimation animation;
            public string[] messages;
        }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public SkeletalAnimBindDialog(ErrorInfo[] errors, bool canCancel)
        {
            InitializeComponent();
            lvwFileList.SetItemCount(errors.Length);

            int index = 0;
            // リスト構築
            foreach (var error in errors)
            {
                ListViewItem item = lvwFileList.Items[index];
                item.Tag = error;

                var builder = new StringBuilder();
                foreach (var message in error.messages)
                {
                    builder.AppendLine(message);
                }

                item.SubItems[clhModel.Index].Text = error.model.FileName;
                item.SubItems[clhAnimation.Index].Text = error.animation.FileName;
                item.SubItems[clhItem.Index].Text = error.messages.Length.ToString();
                Messages.Add(builder.ToString());
                index++;
            }
            if (!canCancel)
            {
                btnOK.Location = btnCancel.Location;
                btnCancel.Visible = false;
            }
            else
            {
                lblDocumentsTitle.Text += res.Strings.SkeletalAnimBindDialog_ChangeBind;
            }
            btnOK.Enabled = true;
            lvwFileList.SetSelectedItem(0);
        }

        private void lvwFileList_SelectionChanged(object sender, EventArgs e)
        {
            var index = lvwFileList.SelectedIndex;
            if (0 <= index && index < Messages.Count)
            {
                tbxDescription.Text = Messages[index];
            }
            else
            {
                tbxDescription.Text = "";
            }
        }
    }
}
