﻿using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;
using App.Data;
using App.Properties;
using App.Utility;
using nw.g3d.iflib;

namespace App.Controls
{
    public sealed partial class ModelMergeDialog : OkCancelDialog
    {
        private readonly Model dstModel_;
        private readonly Model srcModel_;

        public bool IsMergeShape		{ get{ return chkMergeShape.Checked;		} }
        public bool IsMergeVertex		{ get{ return chkMergeVertex.Checked;		} }
        public bool IsMergeScaleEnable	{ get{ return chkMergeScaleEnable.Checked;	} }
        public IEnumerable<IfMergeSrcDstPair> BoneNamePairTable		{ get{ return mtsBone.NameTables;		} }
        public IEnumerable<IfMergeSrcDstPair> MaterialNamePairTable	{ get{ return mtsMaterial.NameTables;	} }

        public bool IsSame { get { return mtsBone.IsSame && mtsMaterial.IsSame; } }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public ModelMergeDialog(Model dstModel, Model srcModel)
        {
            dstModel_ = dstModel;
            srcModel_ = srcModel;

            InitializeComponent();

            DialogUtility.SetHelp(this, HelpUtility.PageKey.p_file_menu_a_mergedialog);

            tbxDstPath.Text = dstModel_.FilePath;
            tbxSrcPath.Text = srcModel_.FilePath;

            // 全般
            {
                chkMergeShape.Checked		= true;
                chkMergeVertex.Checked		= true;
                chkMergeScaleEnable.Checked	= true;
            }

            // ボーン
            {
                mtsBone.OrgSrcNames = srcModel.Bones.Select(x => x.Name).ToArray();
                mtsBone.OrgDstNames = dstModel.Bones.Select(x => x.Name).ToArray();
                mtsBone.TargetImage = Resources.GuiObject_Bone;
                mtsBone.NameTablesChange += (s, e) => lblBoneResultCount0.Text = mtsBone.NameTablesLength.ToString();
                mtsBone.Initialize();
                lblBoneResultCount1.Text = mtsBone.OrgDstNames.Length.ToString();
            }

            // マテリアル
            {
                mtsMaterial.OrgSrcNames = srcModel.Materials.Select(x => x.Name).ToArray();
                mtsMaterial.OrgDstNames = dstModel.Materials.Select(x => x.Name).ToArray();
                mtsMaterial.TargetImage = Resources.GuiObject_Material;
                mtsMaterial.NameTablesChange += (s, e) => lblMaterialResultCount0.Text = mtsMaterial.NameTablesLength.ToString();
                mtsMaterial.Initialize();
                lblMaterialResultCount1.Text = mtsMaterial.OrgDstNames.Length.ToString();
            }
        }

        private void pctSrcTarget_Paint(object sender, PaintEventArgs e)
        {
            DrawTarget(e.Graphics, srcModel_.Name, pctSrcTarget.ClientRectangle);
        }

        private void pctDstTarget_Paint(object sender, PaintEventArgs e)
        {
            DrawTarget(e.Graphics, dstModel_.Name, pctDstTarget.ClientRectangle);
        }

        private void DrawTarget(Graphics g, string name, Rectangle bounds)
        {
            // 背景
            g.Clear(BackColor);

            // アイコン
            Rectangle rcIcon = bounds;
            rcIcon.X += 2;
            rcIcon.Y += (bounds.Height - 16) / 2;
            rcIcon.Size = new Size(16, 16);
            g.DrawImage(Resources.GuiObject_Model, rcIcon);

            // テキスト
            Rectangle rcText = bounds;
            RectangleUtility.OffsetLeft(ref rcText, rcIcon.Width + 2);
            using (StringFormat sf = new StringFormat())
            {
                sf.Alignment     = StringAlignment.Near;
                sf.LineAlignment = StringAlignment.Center;
                sf.Trimming      = StringTrimming.EllipsisCharacter;
                sf.FormatFlags  |= StringFormatFlags.NoWrap;

                g.DrawString(name, Font, SystemBrushes.WindowText, rcText, sf);
            }
        }
    }
}
