﻿using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;
using App.Data;
using App.Properties;
using App.Utility;
using nw.g3d.iflib;

namespace App.Controls
{
    public sealed partial class TexturePatternAnimationMergeDialog : OkCancelDialog
    {
        private readonly TexturePatternAnimation dstTexturePatternAnimation_;
        private readonly TexturePatternAnimation srcTexturePatternAnimation_;

        public IEnumerable<IfMergeSrcDstPair> MaterialNamePairTable	{ get{ return mtsMaterial.NameTables;	} }
        public IEnumerable<IfMergeSrcDstPair> SamplerNamePairTable	{ get{ return mtsSampler.NameTables;	} }

        public bool IsSame { get { return mtsMaterial.IsSame && mtsSampler.IsSame; } }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public TexturePatternAnimationMergeDialog(TexturePatternAnimation dstTexturePatternAnimation, TexturePatternAnimation srcTexturePatternAnimation)
        {
            dstTexturePatternAnimation_ = dstTexturePatternAnimation;
            srcTexturePatternAnimation_ = srcTexturePatternAnimation;

            InitializeComponent();

            DialogUtility.SetHelp(this, HelpUtility.PageKey.p_file_menu_a_mergedialog);

            tbxDstPath.Text = dstTexturePatternAnimation_.FilePath;
            tbxSrcPath.Text = srcTexturePatternAnimation_.FilePath;

            // マテリアル
            {
                mtsMaterial.OrgSrcNames = srcTexturePatternAnimation.TexPatternMatAnims.Select(x => x.mat_name).ToArray();
                mtsMaterial.OrgDstNames = dstTexturePatternAnimation.TexPatternMatAnims.Select(x => x.mat_name).ToArray();
                mtsMaterial.TargetImage = Resources.GuiObject_Material;
                mtsMaterial.NameTablesChange += (s, e) => lblMaterialResultCount0.Text = mtsMaterial.NameTablesLength.ToString();
                mtsMaterial.Initialize();
                lblMaterialResultCount1.Text = mtsMaterial.OrgDstNames.Length.ToString();
            }

            // サンプラ
            {
                mtsSampler.OrgSrcNames = srcTexturePatternAnimation.TexPatternMatAnims.SelectMany(x => x.PatternAnimTargets).Select(y => y.ParentMatName + " / " + y.sampler_name).ToArray();
                mtsSampler.OrgDstNames = dstTexturePatternAnimation.TexPatternMatAnims.SelectMany(x => x.PatternAnimTargets).Select(y => y.ParentMatName + " / " + y.sampler_name).ToArray();
                mtsSampler.TargetImage = Resources.Data_Sampler;
                mtsSampler.NameTablesChange += (s, e) => lblSamplerResultCount0.Text = mtsSampler.NameTablesLength.ToString();
                mtsSampler.Initialize();
                lblSamplerResultCount1.Text = mtsSampler.OrgDstNames.Length.ToString();
            }
        }

        private void pctSrcTarget_Paint(object sender, PaintEventArgs e)
        {
            DrawTarget(e.Graphics, srcTexturePatternAnimation_.Name, pctSrcTarget.ClientRectangle);
        }

        private void pctDstTarget_Paint(object sender, PaintEventArgs e)
        {
            DrawTarget(e.Graphics, dstTexturePatternAnimation_.Name, pctDstTarget.ClientRectangle);
        }

        private void DrawTarget(Graphics g, string name, Rectangle bounds)
        {
            // 背景
            g.Clear(BackColor);

            // アイコン
            Rectangle rcIcon = bounds;
            rcIcon.X += 2;
            rcIcon.Y += (bounds.Height - 16) / 2;
            rcIcon.Size = new Size(16, 16);
            g.DrawImage(Resources.GuiObject_TexturePatternAnimation, rcIcon);

            // テキスト
            Rectangle rcText = bounds;
            RectangleUtility.OffsetLeft(ref rcText, rcIcon.Width + 2);
            using (StringFormat sf = new StringFormat())
            {
                sf.Alignment     = StringAlignment.Near;
                sf.LineAlignment = StringAlignment.Center;
                sf.Trimming      = StringTrimming.EllipsisCharacter;
                sf.FormatFlags  |= StringFormatFlags.NoWrap;

                g.DrawString(name, Font, SystemBrushes.WindowText, rcText, sf);
            }
        }
    }
}
