﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Windows.Forms;

namespace ColorPicker
{
    /// <summary>
    /// カレントカラー表示コントロールクラス。
    /// </summary>
    public sealed class ColorBox : Panel
    {
        public float Gamma
        {
            private get
            {
                return gamma;
            }
            set
            {
                gamma = value;
                Invalidate();
            }
        }
        private float gamma = 1;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ColorBox()
        {
            // ちらつきの防止用
            DoubleBuffered = true;
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void OnSizeChanged(EventArgs e)
        {
            if (DesignMode)
            {
                if (Parent != null)
                {
                    Parent.Invalidate();
                }
            }
            base.OnSizeChanged(e);
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void OnPaint(PaintEventArgs e)
        {
            if (Enabled)
            {
                e.Graphics.Clear(Color.FromArgb(255, App.Utility.ColorUtility.Pow(BackColor, Gamma)));
            }
            else
            {
                e.Graphics.Clear(SystemColors.Control);
            }
        }
    }
}
