﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Drawing;
using System.Windows.Forms;
using nw.g3d.nw4f_3dif;

namespace App.Controls
{
    public class ColorComponentSelectPanel : UIPanel
    {
        private texture_info_comp_selValue[] value_ = null;
        public texture_info_comp_selValue[] Value
        {
            get{
                return value_;
            }
            set
            {
                value_ = value;
                Invalidate();
            }
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            base.OnPaint(e);

            const int edge = 0;

            var color_rect =
                new Rectangle(
                    ClientRectangle.Left + edge,
                    ClientRectangle.Top  + edge,
                    ClientRectangle.Width  - edge * 2 - 1,
                    ClientRectangle.Height - edge * 2 - 1
                );

            if (!DesignMode)
            {
                ColorComponentSelectCommon.DrawColor(e.Graphics, color_rect, Value, Enabled);
            }
        }
    }
}
