﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "msclr/marshal.h"
#include "msclr/marshal_windows.h"
#include "msclr/marshal_cppstd.h"
#include "msclr/marshal_atl.h"

#include "ShaderCommandMaker.h"
#include "CommandUtility.h"
#include "Utility.h"
#include <nw/g3d/res/g3d_ResUtility.h>
#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

using namespace System;
using namespace msclr::interop;
using namespace nw::g3d::edit::detail;

namespace NintendoWare { namespace G3d { namespace Edit {

int ShaderCommandMaker::CalcEditShadingModelValuePacketSize(array<INT32>^ indices)
{
    if (indices == nullptr)
    {
        return -1;
    }

    if (indices->Length <= 0)
    {
        return -1;
    }

    size_t indexByteSize = indices->Length * sizeof(s32);
    size_t valueBlockSize = indexByteSize;

    size_t totalSize =
        nw::g3d::tool::Align(CommandUtility::GetPacketHeaderSize() + CommandUtility::GetEditValueInfoBlockSize() + valueBlockSize, NW_G3D_EDIT_ALIGNMENT);
    return static_cast<int>(totalSize);
}

bool ShaderCommandMaker::MakeEditShadingModelValuePacket(
    array<Byte>^ packetBuffer,
    UINT32 key,
    array<INT32>^ indices,
    TargetEndianKind endianKind)
{
    if (packetBuffer == nullptr)
    {
        return false;
    }
    if (packetBuffer->Length <= 0)
    {
        return false;
    }

    if (indices == nullptr)
    {
        return false;
    }

    if (indices->Length <= 0)
    {
        return false;
    }

    size_t indexByteSize = indices->Length * sizeof(s32);
    size_t valueBlockSize = indexByteSize;

    size_t totalSize =
        nw::g3d::tool::Align(CommandUtility::GetPacketHeaderSize() + CommandUtility::GetEditValueInfoBlockSize() + valueBlockSize, NW_G3D_EDIT_ALIGNMENT);

    if (packetBuffer->Length != totalSize)
    {
        return false;
    }

    pin_ptr<u8> bufferPtr = &packetBuffer[0];

    EditValuePacket* packet = reinterpret_cast<EditValuePacket*>(bufferPtr);
    packet->header = CommandUtility::GetPacketHeader();
    packet->header.command = EDIT_SHADER_COMMAND_FLAG;
    packet->header.dataSize = static_cast<s32>(totalSize - CommandUtility::GetPacketHeaderSize());

    packet->block.key = key;
    packet->block.editTargetKind = EDIT_TARGET_UPDATE_SHADING_MODEL;
    packet->block.length = static_cast<u32>(packet->header.dataSize - CommandUtility::GetEditValueInfoBlockSize());
    packet->block.indexSize = indices->Length;

    EditShadingModelValueBlock* valueBlock = reinterpret_cast<EditShadingModelValueBlock*>(&packet[1]);

    for (u32 i = 0, end = packet->block.indexSize; i < end; ++i)
    {
        valueBlock->index[i] = indices[i];
    }

    if (endianKind == TargetEndianKind::BigEndian)
    {
        u32 indexSize = packet->block.indexSize;
        nw::g3d::tool::Endian::Swap(packet);
        nw::g3d::tool::Endian::SwapIndices(valueBlock, indexSize);
    }
    // pin_ptr 解除
    bufferPtr = nullptr;
    return true;
}

}}} // namespace NintendoWare.G3d.Edit
