﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

using namespace System;
using namespace System::Collections::Generic;

#include "G3dHioLibDefs.h"
#include <nw/g3d/edit/detail/g3d_EditDetailDefs.h>

namespace NintendoWare {
namespace G3d {
namespace Edit {

private ref class ExecuteUserScriptCommand : public EditCommand
{
public:
    //! @brief モデル適用スクリプト用のコンストラクタです。
    ExecuteUserScriptCommand(
        IEditModelTarget^ targetModel,
        String^ scriptText,
        array<Int32>^ selectedBones,
        array<Int32>^ selectedShapes,
        array<Int32>^ selectedMaterials,
        TargetEndianKind targetEndian);

    virtual bool MakeCommandPacket() override;

protected:
    virtual bool CanProcessImpl() override
    {
        return true;
    }

private:
    String^ m_ScriptText;
    IEditModelTarget^ m_TargetModel;
    List<Int32>^ m_SelectedBones;
    List<Int32>^ m_SelectedShapes;
    List<Int32>^ m_SelectedMaterials;

    // モデル以外の適用対象用パラメーター
    String^ m_TargetName;
    nw::g3d::edit::detail::UserScriptTargetKind m_TargetKind;
};

}
}
}
