﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Diagnostics;
using namespace System::Collections::Generic;

#include "G3dHioLibDefs.h"
#include <nw/g3d/edit/g3d_EditDefs.h>

namespace NintendoWare {
namespace G3d {
namespace Edit {

private ref class BindSceneAnimsCommand : public EditAnimsCommand
{
public:
    BindSceneAnimsCommand(TargetEndianKind targetEndian, array<IEditTarget^>^ targetAnims)
        : EditAnimsCommand(targetEndian, targetAnims)
    {
    }

    virtual bool MakeCommandPacket() override;
};

private ref class UnbindSceneAnimsCommand : public EditAnimsCommand
{
public:
    UnbindSceneAnimsCommand(TargetEndianKind targetEndian, array<IEditTarget^>^ targetAnims)
        : EditAnimsCommand(targetEndian, targetAnims)
    {
    }

    virtual bool MakeCommandPacket() override;
};

private ref class EditCameraAnimCurveCommand : public EditAnimCurveCommand
{
public:
    EditCameraAnimCurveCommand(
        TargetEndianKind targetEndian,
        IEditSceneAnimTarget^ target,
        ICurve^ curve,
        UINT32 cameraIndex,
        int targetIndex,
        int curveIndex)
        : EditAnimCurveCommand(targetEndian, target, curve)
    {
        m_CameraIndex = cameraIndex;
        m_TargetIndex = targetIndex;
        m_CurveIndex = curveIndex;
    }

    virtual bool MakeCommandPacket() override;
private:
    UINT32 m_CameraIndex;
    int m_TargetIndex;
    int m_CurveIndex;
};

private ref class EditLightAnimCurveCommand : public EditAnimCurveCommand
{
public:
    EditLightAnimCurveCommand(
        TargetEndianKind targetEndian,
        IEditSceneAnimTarget^ target,
        ICurve^ curve,
        UINT32 lightIndex,
        int targetIndex,
        int curveIndex)
        : EditAnimCurveCommand(targetEndian, target, curve)
    {
        m_LightIndex = lightIndex;
        m_TargetIndex = targetIndex;
        m_CurveIndex = curveIndex;
    }

    virtual bool MakeCommandPacket() override;
private:
    UINT32 m_LightIndex;
    int m_TargetIndex;
    int m_CurveIndex;
};

private ref class EditFogAnimCurveCommand : public EditAnimCurveCommand
{
public:
    EditFogAnimCurveCommand(
        TargetEndianKind targetEndian,
        IEditSceneAnimTarget^ target,
        ICurve^ curve,
        UINT32 fogIndex,
        int targetIndex,
        int curveIndex)
        : EditAnimCurveCommand(targetEndian, target, curve)
    {
        m_FogIndex = fogIndex;
        m_TargetIndex = targetIndex;
        m_CurveIndex = curveIndex;
    }

    virtual bool MakeCommandPacket() override;
private:
    UINT32 m_FogIndex;
    int m_TargetIndex;
    int m_CurveIndex;
};

}}} // namespace NintendoWare.G3d.Edit
