﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "EditSceneAnimCommand.h"
#include "AnimCommandMaker.h"
#include "SceneAnimCommandMaker.h"

using namespace nw::g3d::edit::detail;

namespace NintendoWare {
namespace G3d {
namespace Edit {

bool BindSceneAnimsCommand::MakeCommandPacket()
{
    List<UINT32>^ animationKeys = gcnew List<UINT32>();
    for each(IEditTarget^ targetAnimation in Animations)
    {
        if (targetAnimation->ResFileKey > 0)
        {
            animationKeys->Add(targetAnimation->ResFileKey);
        }
    }

    if (animationKeys->Count <= 0)
    {
        return false;
    }

    int packetSize = AnimCommandMaker::CalcBindAnimationsPacketSize(animationKeys->ToArray());

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return SceneAnimCommandMaker::MakeBindSceneAnimationsPacket(
        PacketBuffer,
        SCENE_ANIMATION_BIND_COMMAND_FLAG,
        animationKeys->ToArray(),
        TargetEndian);
}

bool UnbindSceneAnimsCommand::MakeCommandPacket()
{
    List<UINT32>^ animationKeys = gcnew List<UINT32>();
    for each(IEditTarget^ targetAnimation in Animations)
    {
        if (targetAnimation->ResFileKey > 0)
        {
            animationKeys->Add(targetAnimation->ResFileKey);
        }
    }

    if (animationKeys->Count <= 0)
    {
        return false;
    }

    int packetSize = AnimCommandMaker::CalcBindAnimationsPacketSize(animationKeys->ToArray());

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return SceneAnimCommandMaker::MakeBindSceneAnimationsPacket(
        PacketBuffer,
        SCENE_ANIMATION_UNBIND_COMMAND_FLAG,
        animationKeys->ToArray(),
        TargetEndian);
}

bool EditCameraAnimCurveCommand::MakeCommandPacket()
{
    nw::g3d::tool::EditBinAnimCurve animCurve;

    static u32 enumTable[] =
    {
        4, 5, 6, // pos[3]
        7, 8, 9, // aim[3]
        10,      // twist
        7, 8, 9, // rotate[3]
        2,       // aspect
        0,       // nearZ
        1,       // farZ
        3,       // height
        3        // fovy
    };

    if (!AnimCommandMaker::CreateAnimCurve(&animCurve, sizeof(bit32)*enumTable[m_TargetIndex], Curve))
    {
        return false;
    }

    int packetSize = AnimCommandMaker::CalcEditAnimCurvePacketSize(&animCurve);
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return SceneAnimCommandMaker::MakeEditCameraAnimCurvePacket(
        PacketBuffer,
        &animCurve,
        Target->ResFileKey,
        m_CameraIndex,
        m_CurveIndex,
        TargetEndian);
}

bool EditLightAnimCurveCommand::MakeCommandPacket()
{
    nw::g3d::tool::EditBinAnimCurve animCurve;

    static u32 enumTable[] =
    {
        0,          // enable
        1, 2, 3,    // pos[3]
        4, 5, 6,    // dir[3]
        4, 5, 6,    // aim[3]
        7, 8,       // distAttn[2]
        9, 10,      // angleAttn[2]
        11, 12, 13, // color[0][3]
        14, 15, 16  // color[1][3]
    };

    if (!AnimCommandMaker::CreateAnimCurve(&animCurve, sizeof(bit32)*enumTable[m_TargetIndex], Curve))
    {
        return false;
    }

    int packetSize = AnimCommandMaker::CalcEditAnimCurvePacketSize(&animCurve);
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return SceneAnimCommandMaker::MakeEditLightAnimCurvePacket(
        PacketBuffer,
        &animCurve,
        Target->ResFileKey,
        m_LightIndex,
        m_CurveIndex,
        TargetEndian);
}

bool EditFogAnimCurveCommand::MakeCommandPacket()
{
    nw::g3d::tool::EditBinAnimCurve animCurve;

    static u32 enumTable[] =
    {
        0, 1,       // distAttn[2]
        2, 3, 4     // color[3]
    };

    if (!AnimCommandMaker::CreateAnimCurve(&animCurve, sizeof(bit32)*enumTable[m_TargetIndex], Curve))
    {
        return false;
    }

    int packetSize = AnimCommandMaker::CalcEditAnimCurvePacketSize(&animCurve);
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return SceneAnimCommandMaker::MakeEditFogAnimCurvePacket(
        PacketBuffer,
        &animCurve,
        Target->ResFileKey,
        m_FogIndex,
        m_CurveIndex,
        TargetEndian);
}

}}} // namespace NintendoWare.G3d.Edit
