﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Diagnostics;
using namespace System::Collections::Generic;

#include "G3dHioLibDefs.h"
#include <nw/g3d/edit/g3d_EditDefs.h>

namespace NintendoWare {
namespace G3d {
namespace Edit {

private ref class EditShaderParamCurveCommand : public EditAnimCurveCommand
{
public:
    EditShaderParamCurveCommand(
        TargetEndianKind targetEndian,
        IEditTarget^ target,
        ICurve^ curve,
        UINT32 materialNameIndex,
        int curveIndex,
        UINT32 componentIndex)
        : EditAnimCurveCommand(targetEndian, target, curve)
    {
        m_MaterialNameIndex = materialNameIndex;
        m_ComponentIndex = componentIndex;
        m_CurveIndex = curveIndex;
    }

    virtual bool MakeCommandPacket() override;
private:
    UINT32 m_MaterialNameIndex;
    UINT32 m_ComponentIndex;
    int m_CurveIndex;
};

private ref class EditTexPatternCurveCommand : public EditAnimCurveCommand
{
public:
    EditTexPatternCurveCommand(
        TargetEndianKind targetEndian,
        IEditTarget^ target,
        ICurve^ curve,
        UINT32 materialNameIndex,
        int curveIndex)
        : EditAnimCurveCommand(targetEndian, target, curve)
    {
        m_MaterialNameIndex = materialNameIndex;
        m_CurveIndex = curveIndex;
    }

    virtual bool MakeCommandPacket() override;
private:
    UINT32 m_MaterialNameIndex;
    int m_CurveIndex;
};

private ref class EditMaterialCurveCommand : public EditAnimCurveCommand
{
public:
    EditMaterialCurveCommand(
        TargetEndianKind targetEndian,
        IEditTarget^ target,
        ICurve^ curve,
        UINT32 materialNameIndex,
        int curveIndex,
        UINT32 componentIndex)
        : EditAnimCurveCommand(targetEndian, target, curve)
        , m_MaterialNameIndex(materialNameIndex)
        , m_ComponentIndex(componentIndex)
        , m_CurveIndex(curveIndex)
    {
    }

    virtual bool MakeCommandPacket() override;
private:
    UINT32 m_MaterialNameIndex;
    UINT32 m_ComponentIndex;
    int m_CurveIndex;
};

private ref class EditMatVisibilityCurveCommand : public EditAnimCurveCommand
{
public:
    EditMatVisibilityCurveCommand(
        TargetEndianKind targetEndian,
        IEditTarget^ target,
        ICurve^ curve,
        int curveIndex,
        UINT32 animIndex)
        : EditAnimCurveCommand(targetEndian, target, curve)
    {
        m_CurveIndex = curveIndex;
        m_AnimIndex = animIndex;
    }

    virtual bool MakeCommandPacket() override;
private:
    int m_CurveIndex;
    UINT32 m_AnimIndex;
};

private ref class EditBoneVisibilityCurveCommand : public EditAnimCurveCommand
{
public:
    EditBoneVisibilityCurveCommand(
        TargetEndianKind targetEndian,
        IEditTarget^ target,
        ICurve^ curve,
        int curveIndex,
        UINT32 animIndex)
        : EditAnimCurveCommand(targetEndian, target, curve)
    {
        m_CurveIndex = curveIndex;
        m_AnimIndex = animIndex;
    }

    virtual bool MakeCommandPacket() override;
private:
    int m_CurveIndex;
    UINT32 m_AnimIndex;
};

private ref class EditShapeCurveCommand : public EditAnimCurveCommand
{
public:
    EditShapeCurveCommand(
        TargetEndianKind targetEndian,
        IEditTarget^ target,
        ICurve^ curve,
        UINT32 animIndex,
        int curveIndex)
        : EditAnimCurveCommand(targetEndian, target, curve)
    {
        m_AnimIndex = animIndex;
        m_CurveIndex = curveIndex;
    }

    virtual bool MakeCommandPacket() override;
private:
    UINT32 m_AnimIndex;
    int m_CurveIndex;
};

private ref class EditModelAnimPlayCommand : public EditAnimCommand
{
public:
    EditModelAnimPlayCommand(
        TargetEndianKind targetEndian,
        IEditModelTarget^ targetModel,
        IEditTarget^ target,
        float value)
        : EditAnimCommand(targetEndian, target)
        , m_TargetModel(targetModel)
    {
        m_Value = value;
    }

    virtual bool MakeCommandPacket() override;
private:
    float m_Value;
    IEditModelTarget^ m_TargetModel;
};

private ref class EditModelAnimStopCommand : public EditAnimCommand
{
public:
    EditModelAnimStopCommand(
        TargetEndianKind targetEndian,
        IEditTarget^ target,
        float value)
        : EditAnimCommand(targetEndian, target)
    {
        m_Value = value;
    }

    EditModelAnimStopCommand(
        TargetEndianKind targetEndian,
        IEditModelTarget^ targetModel,
        IEditTarget^ target,
        float value)
        : EditAnimCommand(targetEndian, target)
        , m_TargetModel(targetModel)
    {
        m_Value = value;
    }

    virtual bool MakeCommandPacket() override;
private:
    float m_Value;
    IEditModelTarget^ m_TargetModel;
};


}}} // namespace NintendoWare.G3d.Edit
