﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "EditMaterialCommand.h"
#include "MaterialCommandMaker.h"
#include "CommandMaker.h"

using namespace nw::g3d::edit::detail;

namespace NintendoWare {
namespace G3d {
namespace Edit {

generic<typename ValueType>
bool EditMaterialValueCommand<ValueType>::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcEditValuePacketSize(Indices);
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return MaterialCommandMaker::MakeEditMaterialValuePacket<ValueType>(
        PacketBuffer,
        m_EditTargetKind,
        Target->ModelObjKey,
        Indices,
        Value,
        TargetEndian);
}

bool EditMaterialValueU16Command::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcEditValuePacketSize(Indices);
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return MaterialCommandMaker::MakeEditMaterialValueU16Packet(
        PacketBuffer,
        m_EditTargetKind,
        Target->ModelObjKey,
        Indices,
        m_HighValue,
        m_LowValue,
        TargetEndian);
}

generic<typename ValueType>
bool EditMaterialSamplerValueCommand<ValueType>::MakeCommandPacket()
{
    int packetSize = MaterialCommandMaker::CalcEditMaterialSamplerValuePacketSize(Indices);
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return MaterialCommandMaker::MakeEditMaterialSamplerValuePacket<ValueType>(
        PacketBuffer,
        m_EditTargetKind,
        Target->ModelObjKey,
        Indices,
        m_SamplerIndex,
        Value,
        TargetEndian);
}

bool EditMaterialVector4ValueFloatCommand::MakeCommandPacket()
{
    int packetSize = MaterialCommandMaker::CalcEditMaterialVector4ValuePacketSize(Indices);
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return MaterialCommandMaker::MakeEditMaterialVector4ValueFloatPacket(
        PacketBuffer,
        m_EditTargetKind,
        Target->ModelObjKey,
        Indices,
        m_Value,
        TargetEndian);
}

generic<typename ValueType>
bool EditMaterialShaderParamVectorValueCommand<ValueType>::MakeCommandPacket()
{
    int packetSize = MaterialCommandMaker::CalcEditMaterialShaderParamVectorValuePacketSize(Indices);
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return MaterialCommandMaker::MakeEditMaterialShaderParamVectorValuePacket<ValueType>(
        PacketBuffer,
        m_EditTargetKind,
        Target->ModelObjKey,
        m_ParamName,
        Indices,
        m_Value,
        TargetEndian);
}

bool EditMaterialShaderParamMatrixValueCommand::MakeCommandPacket()
{
    int packetSize = MaterialCommandMaker::CalcEditMaterialShaderParamMatrixValuePacketSize(Indices);
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return MaterialCommandMaker::MakeEditMaterialShaderParamMatrixValuePacket(
        PacketBuffer,
        m_EditTargetKind,
        Target->ModelObjKey,
        m_ParamName,
        Indices,
        m_Value,
        TargetEndian);
}

bool EditBlinkMaterialsCommand::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcEditValuePacketSize(Indices);
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return CommandMaker::MakeEditValuePacket(
        PacketBuffer,
        PICK_RUNTIME_MATERIAL_COMMAND_FLAG,
        EDIT_TARGET_KIND_MAX,
        Target->ModelObjKey,
        Indices,
        0,
        TargetEndian);
}

}}} // namespace NintendoWare.G3d.Edit
