﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "EditBoneCommand.h"
#include "CommandMaker.h"

using namespace nw::g3d::edit::detail;

namespace NintendoWare {
namespace G3d {
namespace Edit {

generic<typename ValueType>
bool EditBoneValueCommand<ValueType>::MakeCommandPacket()
{
    int packetSize = CommandMaker::CalcEditValuePacketSize(Indices);

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return CommandMaker::MakeEditValuePacket<ValueType>(
        PacketBuffer,
        EDIT_BONE_COMMAND_FLAG,
        m_EditTargetKind,
        Target->ModelObjKey,
        Indices,
        Value,
        TargetEndian);
}

}}} // namespace NintendoWare.G3d.Edit
