﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "EditAnimCommand.h"
#include "AnimCommandMaker.h"

using namespace nw::g3d::edit::detail;

namespace NintendoWare {
namespace G3d {
namespace Edit {

bool BindAnimsCommand::MakeCommandPacket()
{
    List<UINT32>^ animationKeys = gcnew List<UINT32>();
    for each(IEditTarget^ targetAnimation in Animations)
    {
        if (targetAnimation->ResFileKey > 0)
        {
            animationKeys->Add(targetAnimation->ResFileKey);
        }
    }

    if (animationKeys->Count <= 0)
    {
        return false;
    }

    int packetSize = AnimCommandMaker::CalcBindAnimationsPacketSize(animationKeys->ToArray());

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return AnimCommandMaker::MakeBindAnimationsPacket(
        PacketBuffer,
        MODEL_ANIMATION_BIND_COMMAND_FLAG,
        Target->ModelObjKey,
        animationKeys->ToArray(),
        Target->IsAttached,
        TargetEndian);
}

bool UnbindAnimsCommand::MakeCommandPacket()
{
    List<UINT32>^ animationKeys = gcnew List<UINT32>();
    for each(IEditTarget^ targetAnimation in Animations)
    {
        if (targetAnimation->ResFileKey > 0)
        {
            animationKeys->Add(targetAnimation->ResFileKey);
        }
    }

    if (animationKeys->Count <= 0)
    {
        return false;
    }

    int packetSize = AnimCommandMaker::CalcBindAnimationsPacketSize(animationKeys->ToArray());

    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return AnimCommandMaker::MakeBindAnimationsPacket(
        PacketBuffer,
        MODEL_ANIMATION_UNBIND_COMMAND_FLAG,
        Target->ModelObjKey,
        animationKeys->ToArray(),
        Target->IsAttached,
        TargetEndian);
}

bool EditRetargetingHostModelCommand::MakeCommandPacket()
{
    int packetSize = AnimCommandMaker::CalcAnimEditInfoPacketSize();
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    UINT32 modelKey = 0;
    if (m_RetargetingHostModel != nullptr)
    {
        modelKey = m_RetargetingHostModel->ModelObjKey;
    }

    return AnimCommandMaker::MakeAnimEditInfoPacket(
        PacketBuffer,
        modelKey,
        Target->ResFileKey,
        MODEL_ANIMATION_EDIT_RETARGET_HOST_MODEL_COMMAND_FLAG,
        0,
        TargetEndian);
}

bool EditPlayMotionMirroringCommand::MakeCommandPacket()
{
    int packetSize = AnimCommandMaker::CalcAnimEditInfoPacketSize();
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return AnimCommandMaker::MakeAnimEditInfoPacket(
        PacketBuffer,
        0,
        Target->ResFileKey,
        MODEL_ANIMATION_EDIT_MIRRORING_ENABLED_COMMAND_FLAG,
        m_IsEnabled,
        TargetEndian);
}

bool EditPlayPolicyCommand::MakeCommandPacket()
{
    int packetSize = AnimCommandMaker::CalcEditFrameCtrlPacketSize();
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return AnimCommandMaker::MakeEditFrameCtrlPacket(
        PacketBuffer,
        nn::g3d::viewer::detail::ANIMATION_PLAY_POLICY_COMMAND_FLAG,
        0.f,
        1.f,
        m_Policy,
        0.0f,
        0.f,
        TargetEndian);
}

bool EditPlayFrameCtrlCommand::MakeCommandPacket()
{
    int packetSize = AnimCommandMaker::CalcEditFrameCtrlPacketSize();
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return AnimCommandMaker::MakeEditFrameCtrlPacket(
        PacketBuffer,
        nn::g3d::viewer::detail::ANIMATION_PLAY_FRAME_CTRL_COMMAND_FLAG,
        m_Frame,
        1.f,
        nn::g3d::viewer::detail::EDIT_PLAY_POLICY_AUTO,
        0.0f,
        0.f,
        TargetEndian);
}

bool EditStopFrameCtrlCommand::MakeCommandPacket()
{
    int packetSize = AnimCommandMaker::CalcEditFrameCtrlPacketSize();
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return AnimCommandMaker::MakeEditFrameCtrlPacket(
        PacketBuffer,
        nn::g3d::viewer::detail::ANIMATION_STOP_FRAME_CTRL_COMMAND_FLAG,
        m_Frame,
        1.f,
        nn::g3d::viewer::detail::EDIT_PLAY_POLICY_AUTO,
        0.0f,
        0.f,
        TargetEndian);
}

bool EditFrameStepCommand::MakeCommandPacket()
{
    int packetSize = AnimCommandMaker::CalcEditFrameCtrlPacketSize();
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return AnimCommandMaker::MakeEditFrameCtrlPacket(
        PacketBuffer,
        nn::g3d::viewer::detail::ANIMATION_FRAME_STEP_COMMAND_FLAG,
        0.f,
        m_Value,
        nn::g3d::viewer::detail::EDIT_PLAY_POLICY_AUTO,
        0.0f,
        0.f,
        TargetEndian);
}

bool EditFrameCountCommand::MakeCommandPacket()
{
    int packetSize = AnimCommandMaker::CalcEditFrameCtrlPacketSize();
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return AnimCommandMaker::MakeEditFrameCtrlPacket(
        PacketBuffer,
        nn::g3d::viewer::detail::ANIMATION_FRAME_COUNT_COMMAND_FLAG,
        0.f,
        1.f,
        nn::g3d::viewer::detail::EDIT_PLAY_POLICY_AUTO,
        0.0f,
        m_Value,
        TargetEndian);
}

bool EditStartFrameCommand::MakeCommandPacket()
{
    int packetSize = AnimCommandMaker::CalcEditFrameCtrlPacketSize();
    if (packetSize == -1)
    {
        return false;
    }

    AllocPacketBuffer(packetSize);

    return AnimCommandMaker::MakeEditFrameCtrlPacket(
        PacketBuffer,
        nn::g3d::viewer::detail::ANIMATION_START_FRAME_COMMAND_FLAG,
        0.f,
        1.f,
        nn::g3d::viewer::detail::EDIT_PLAY_POLICY_AUTO,
        m_Value,
        0.0f,
        TargetEndian);
}

}}} // namespace NintendoWare.G3d.Edit
