﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"

#include "msclr/marshal.h"
#include "msclr/marshal_windows.h"
#include "msclr/marshal_cppstd.h"
#include "msclr/marshal_atl.h"

#include "CommandUtility.h"
#include "Utility.h"
#include "HIO.h"
#include <nn/g3d/viewer/detail/g3d_ViewerPacketDefine.h>

using namespace System;
using namespace msclr::interop;
using namespace nw::g3d::edit::detail;

namespace NintendoWare { namespace G3d { namespace Edit {

PacketHeader CommandUtility::GetPacketHeader()
{
    PacketHeader header;
    header.command = 0;
    header.dataSize = 0;
    header.magic = NN_G3D_EDIT_MAGIC;
    header.verWord = NN_G3D_EDIT_VERSION;

    return header;
}

nn::g3d::viewer::detail::PacketHeader CommandUtility::GetNnG3dViewerPacketHeader()
{
    nn::g3d::viewer::detail::PacketHeader header;
    header.command = 0;
    header.dataSize = 0;
    header.magic = NN_G3D_EDIT_MAGIC;
    header.verWord = NN_G3D_EDIT_VERSION;

    return header;
}

size_t CommandUtility::GetPacketHeaderSize()
{
    switch (HIO::GetInstance()->TargetDeviceType)
    {
    case HIOBase::TargetType::OldPc:
    case HIOBase::TargetType::Cafe:
        return sizeof(nw::g3d::edit::detail::PacketHeader);
    case HIOBase::TargetType::Htc:
        return sizeof(nn::g3d::viewer::detail::PacketHeader);
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

size_t CommandUtility::GetFileDataBlockSize()
{
    return sizeof(FileDataBlock);
}

size_t CommandUtility::GetEditValueInfoBlockSize()
{
    return sizeof(EditValueInfoBlock);
}

size_t GetModelOptimizedShaderPacketSize()
{
    switch (HIO::GetInstance()->TargetDeviceType)
    {
    case HIOBase::TargetType::Cafe:
    case HIOBase::TargetType::OldPc:
        return sizeof(nw::g3d::edit::detail::ModelOptimizedShaderPacket);
    case HIOBase::TargetType::Htc:
        return sizeof(nn::g3d::viewer::detail::ModelOptimizedShaderPacket);
    default:
        unexpected();
    }
}

size_t CommandUtility::GetModelOptimizedShaderBlockSize(int fileCount, int materialCount)
{
    --fileCount; //構造体にファイル一個分が存在するので、一つ減らす
    --materialCount; // 同上
    size_t size = GetModelOptimizedShaderPacketSize();
    size += sizeof(FileInfoData);
    size += sizeof(FileInfoData::OffsetFileInfo) * fileCount;
    size += sizeof(nn::g3d::viewer::detail::MaterialShaderInfoArrayData);
    size += sizeof(nn::g3d::viewer::detail::MaterialShaderInfoData) * materialCount;
    return static_cast<u32>(size);
}

}}} // namespace NintendoWare.G3d.Edit
