﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.G3d.Edit
{
    public class ModifiedShaderProgramRecvData
    {
        private uint shaderArchiveKey = 0;
        private int shadingModelIndex = -1;
        private int shaderProgramIndex = -1;
        private List<IShaderCompileInfo> shaderCompileInfoArray = new List<IShaderCompileInfo>();

        public ModifiedShaderProgramRecvData(uint shaderArchiveKey, int shadingModelIndex, int shaderProgramIndex)
        {
            this.shaderArchiveKey = shaderArchiveKey;
            this.shadingModelIndex = shadingModelIndex;
            this.shaderProgramIndex = shaderProgramIndex;
        }

        public uint ShaderArchiveKey
        {
            get { return this.shaderArchiveKey; }
        }

        public int ShadingModelIndex
        {
            get { return this.shadingModelIndex; }
        }

        public int ShaderProgramIndex
        {
            get { return this.shaderProgramIndex; }
        }

        public IList<IShaderCompileInfo> ShaderCompileInfoArray
        {
            get { return this.shaderCompileInfoArray; }
        }

        public void AddShaderCompileInfo(string option, string choice)
        {
            string copyOption = string.Copy(option);
            string copyChoice = string.Copy(choice);

            ShaderCompileInfo info = new ShaderCompileInfo(copyOption, copyChoice);
            this.shaderCompileInfoArray.Add(info);
        }
    }
}
