﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.G3d.Edit
{
    public enum InterpolationType
    {
        Hermite,
        Linear,
        Step
    }

    public enum FrameType
    {
        None,
        Frame32,
        Frame16,
        Frame8
    }

    public enum KeyType
    {
        None,
        Key32,
        Key16,
        Key8
    }

    public enum WrapType
    {
        Clamp,
        Repeat,
        Mirror,
        RelativeRepeat
    }

    public enum ValueType
    {
        Float,
        Int,
        Bool
    }

    public interface ICurve
    {
        ICurveValue[] ValueArray
        {
            get;
        }

        IEnumerable<ICurveValue> CurveValues
        {
            get;
        }

        InterpolationType InterpolationType
        {
            get;
        }

        FrameType FrameType
        {
            get;
        }

        KeyType KeyType
        {
            get;
        }

        WrapType PreWrap
        {
            get;
        }

        WrapType PostWrap
        {
            get;
        }

        ValueType ValueType
        {
            get;
        }

        float Scale { get; }
        float Offset { get; }
        bool IsBaked { get; }

        bool IsDegreeValue { get; }
    }

    public interface ICurve<T> : ICurve where T : ICurveValue
    {
        IEnumerable<T> Values
        {
            get;
        }
    }
}
