﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using NintendoWare.G3d.Edit.Math;

namespace NintendoWare.G3d.Edit
{
    /// <summary>
    /// 処理結果コードです。
    /// </summary>
    public enum HtcResultCode
    {
        Success = 0,
        NullDevice = 1,
        SocketAlreadyOpened = 2,
        SocketRecvFailed = 3,
        ValidEditPortNotFound = 4,
        ValidEditPingPortNotFound = 5,
        NotImplemented = 6,
        InvalidSocket = 7,
        SocketConnectFailed = 8,
        CreateSocketFailed = 9,
        SocketSendFailed = 10
    }

    /// <summary>
    /// エラー詳細コードです。
    /// </summary>
    public enum HtcErrorDetailCode
    {
        NoDetail = 0,

        // socketの返すエラー (全部はないので必要になったら足す)
        SocketErrorUnknown = 1,
        SocketErrorNoBuffurs = 2,
        SocketErrorProtocolNoSupport = 3,
        SocketErrorProtocolType = 4,
        SocketErrorTimeout = 5,
        SocketErrorConnectionRefused = 6,
        SocketErrorNetOrHostDown = 7,
        SocketErrorNetOrHostUnreach = 8,
        SocketErrorAccess = 9,
        SocketErrorAdressFamilyNoSupport = 10,
        SocketErrorInvalid = 11,
        SocketErrorMaxFileTable = 12,
        SocketErrorWouldBlock = 13,
        SocketErrorNotSock = 14,
        SocketErrorGracefullyClosed = 15,
    }

    /// <summary>
    /// 処理結果を格納するクラスです
    /// </summary>
    public class HtcResult
    {
        private HtcResultCode resultCode = HtcResultCode.Success;
        private HtcErrorDetailCode errorDetailCode = HtcErrorDetailCode.NoDetail;
        private int errorDetailRawValue = 0;

        public bool IsSuccess
        {
            get
            {
                return this.resultCode == HtcResultCode.Success;
            }
        }

        public HtcResultCode ResultCode
        {
            get
            {
                return this.resultCode;
            }

            set
            {
                this.resultCode = value;
            }
        }

        public HtcErrorDetailCode ErrorDetailCode
        {
            get
            {
                return this.errorDetailCode;
            }

            set
            {
                this.errorDetailCode = value;
            }
        }

        public int ErrorDetailRawValue
        {
            get
            {
                return this.errorDetailRawValue;
            }

            set
            {
                this.errorDetailRawValue = value;
            }
        }
    }
}
