﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.G3d.Edit
{
    public enum BillboardKind
    {
        /// <summary>
        /// ビルボードなし
        /// </summary>
        None,

        /// <summary>
        /// ワールド
        /// </summary>
        World,

        /// <summary>
        /// ワールドビューポイント
        /// </summary>
        WorldViewpoint,

        /// <summary>
        /// スクリーン
        /// </summary>
        Screen,

        /// <summary>
        /// スクリーンビューポイント
        /// </summary>
        ScreenViewpoint,

        /// <summary>
        /// Ｙ軸
        /// </summary>
        YAxis,

        /// <summary>
        /// Ｙ軸ビューポイント
        /// </summary>
        YAxisViewpoint,
    }
}
