﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;

namespace Nintendo.InGameEditing.WPF
{
    internal class IgeOrientationConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            if (value is UI.Orientation)
            {
                var orientation = (UI.Orientation)value;
                if (orientation == UI.Orientation.Horizontal) return Orientation.Horizontal;
                else if (orientation == UI.Orientation.Vertical) return Orientation.Vertical;
            }
            return DependencyProperty.UnsetValue;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotSupportedException();
        }
    }
}
