﻿using System;
using System.Text;

namespace Nintendo.InGameEditing
{
    internal class StringTypeSerializer : ITypeSerializer<string>
    {
        private static readonly Encoding Encoding = Encoding.UTF8;
        private static readonly byte[] NullTerminatedBytes = new byte[1];

        /// <summary>
        /// 文字列を null 終端された UTF-8 文字列にシリアライズします。
        /// </summary>
        /// <param name="value">シリアライズする文字列</param>
        /// <returns>文字列のバイト列表現</returns>
        public byte[] Serialize(string value)
        {
            value = value?.TrimEnd('\0');
            if (string.IsNullOrEmpty(value)) { return NullTerminatedBytes; }

            var bytes = Encoding.GetBytes(value);
            var buffer = new byte[bytes.Length + 1];
            Buffer.BlockCopy(bytes, 0, buffer, 0, bytes.Length);

            return buffer;
        }

        public string Deserialize(byte[] data)
        {
            if (data == null || data.Length == 0) { return string.Empty; }
            return Encoding.GetString(data).TrimEnd('\0');
        }

        internal static void RegisterTo(DefaultTypeSerializerProvider provider)
            => provider?.Register(new[] { "string", "String" }, typeof(string), new StringTypeSerializer());
    }
}
