﻿using System;

namespace Nintendo.InGameEditing
{
    internal class BoolTypeSerializer : ITypeSerializer<bool>
    {
        byte[] ITypeSerializer<bool>.Serialize(bool value) => BitConverter.GetBytes(value);

        bool ITypeSerializer<bool>.Deserialize(byte[] data) => BitConverter.ToBoolean(data, 0);

        internal static void RegisterTo(DefaultTypeSerializerProvider provider)
            => provider?.Register(new[] { "bool" }, typeof(bool), new BoolTypeSerializer());
    }
}
