﻿using System;

namespace Nintendo.InGameEditing
{
    /// <summary>
    /// ノードが削除された事由を示します。
    /// </summary>
    public enum RemovedReason
    {
        /// <summary>
        /// ランタイムからの通知によりノードが削除されたことを示します。
        /// </summary>
        Deleted,

        /// <summary>
        /// サービスの切断により削除されたことを示します。
        /// </summary>
        Disconnected,
    }

    /// <summary>
    /// ノードの削除時に発行されるイベントの引数です。
    /// </summary>
    public class RemovedEventArgs : EventArgs
    {
        /// <summary>
        /// 通知により削除された際のイベント引数を取得します。
        /// </summary>
        public static RemovedEventArgs Deleted { get; } = new RemovedEventArgs(RemovedReason.Deleted);

        /// <summary>
        /// 切断により削除された際のイベント引数を取得します。
        /// </summary>
        public static RemovedEventArgs Disconnected { get; } = new RemovedEventArgs(RemovedReason.Disconnected);

        internal RemovedEventArgs(RemovedReason reason)
        {
            Reason = reason;
        }

        /// <summary>
        /// ノードが削除された事由を取得します。
        /// </summary>
        public RemovedReason Reason { get; }
    }
}
