﻿using System.IO;
using Nintendo.InGameEditing.Communication;

namespace Nintendo.InGameEditing.Messages
{
    internal class ValueMessage : NodeTargetMessage
    {
        public static MessageType MessageType => MessageType.Value;

        public ValueMessage(uint id, byte[] value) : base(id)
        {
            Value = value ?? Const.EmptyBytes;
        }

        public byte[] Value { get; }

        internal static ValueMessage Parse(Packet packet)
        {
            using (var stream = new MemoryStream(packet.Payload))
            using (var reader = new BinaryReader(stream))
            {
                var messageType = (MessageType)reader.ReadInt32();
                if (messageType != MessageType) { throw new InvalidDataException(); }

                var id = reader.ReadUInt32();
                var value = reader.ReadBytes((int)(stream.Length - stream.Position));

                return new ValueMessage(id, value);
            }
        }

        public override Packet ToPacket()
        {
            using (var stream = new MemoryStream(sizeof(uint)))
            using (var writer = new BinaryWriter(stream))
            {
                writer.Write(Id);
                writer.Write(Value);

                return MessageHelper.CreatePacket(MessageType, stream.ToArray());
            }
        }
    }
}
