﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "stdafx.h"
#include "dllInterface.h"
#include "atkTool_BfwavReader.h"
#include "atkTool_BfstmReader.h"

#define REQUIRES(exp, returnValue) if(!(exp)) { return returnValue; }

extern "C" void nninitStartup()
{
}

nnatktoolResult OpenBfwav(void* bfwavData, void** outHandle)
{
    REQUIRES(bfwavData != nullptr, ResultInvalidArgument);
    REQUIRES(outHandle != nullptr, ResultInvalidArgument);

    auto instance = new nn::atkTool::detail::BfwavReader(bfwavData);

    if(instance == nullptr)
    {
        return ResultOutOfMemory;
    }

    if(!instance->IsAvailable())
    {
        delete instance;
        *outHandle = nullptr;

        return ResultNotSupported;
    }

    *outHandle = instance;

    return ResultSuccess;
}

nnatktoolResult CloseBfwav(void* handle)
{
    REQUIRES(handle != nullptr, ResultInvalidArgument);

    delete reinterpret_cast<nn::atkTool::detail::BfwavReader*>(handle);
    return ResultSuccess;
}

nnatktoolResult GetBfwavWaveBinaryInfo(void* handle, nnatktoolWaveBinaryInfo* info)
{
    REQUIRES(handle != nullptr, ResultInvalidArgument);
    REQUIRES(info != nullptr, ResultInvalidArgument);

    auto instance = reinterpret_cast<nn::atkTool::detail::BfwavReader*>(handle);
    instance->GetWaveBinaryInfo(*info);

    return ResultSuccess;
}

uint64_t GetRequiredBufferSizeForDecodeBfwav(void* handle)
{
    REQUIRES(handle != nullptr, 0);

    auto instance = reinterpret_cast<nn::atkTool::detail::BfwavReader*>(handle);
    return static_cast<uint64_t>(instance->GetRequiredBufferSizeForDecodeAll());
}

nnatktoolResult DecodeBfwav(void* handle, int channel, void* outputBuffer, uint64_t outputBufferSize)
{
    REQUIRES(handle != nullptr, ResultInvalidArgument);
    REQUIRES(channel >= 0, ResultInvalidArgument);
    REQUIRES(outputBuffer != nullptr, ResultInvalidArgument);
    REQUIRES(outputBufferSize > 0, ResultInvalidArgument);

    auto instance = reinterpret_cast<nn::atkTool::detail::BfwavReader*>(handle);
    return instance->DecodeAll(channel, outputBuffer, static_cast<size_t>(outputBufferSize));
}

nnatktoolResult OpenBfstm(void* bfstmData, void** outHandle)
{
    REQUIRES(bfstmData != nullptr, ResultInvalidArgument);
    REQUIRES(outHandle != nullptr, ResultInvalidArgument);

    auto instance = new nn::atkTool::detail::BfstmReader(bfstmData);

    if(instance == nullptr)
    {
        return ResultOutOfMemory;
    }

    if(!instance->IsAvailable())
    {
        delete instance;
        *outHandle = nullptr;

        return ResultNotSupported;
    }

    *outHandle = instance;

    return ResultSuccess;
}

nnatktoolResult CloseBfstm(void* handle)
{
    REQUIRES(handle != nullptr, ResultInvalidArgument);

    delete reinterpret_cast<nn::atkTool::detail::BfstmReader*>(handle);
    return ResultSuccess;
}

nnatktoolResult GetBfstmWaveBinaryInfo(void* handle, nnatktoolWaveBinaryInfo* info)
{
    REQUIRES(handle != nullptr, ResultInvalidArgument);
    REQUIRES(info != nullptr, ResultInvalidArgument);

    auto instance = reinterpret_cast<nn::atkTool::detail::BfstmReader*>(handle);
    instance->GetWaveBinaryInfo(*info);

    return ResultSuccess;
}

uint64_t GetRequiredBufferSizeForDecodeBfstm(void* handle)
{
    REQUIRES(handle != nullptr, 0);

    auto instance = reinterpret_cast<nn::atkTool::detail::BfstmReader*>(handle);
    return static_cast<uint64_t>(instance->GetRequiredBufferSizeForDecodeAll());
}

nnatktoolResult DecodeBfstm(void* handle, int channel, void* outputBuffer, uint64_t outputBufferSize)
{
    REQUIRES(handle != nullptr, ResultInvalidArgument);
    REQUIRES(channel >= 0, ResultInvalidArgument);
    REQUIRES(outputBuffer != nullptr, ResultInvalidArgument);
    REQUIRES(outputBufferSize > 0, ResultInvalidArgument);

    auto instance = reinterpret_cast<nn::atkTool::detail::BfstmReader*>(handle);
    return instance->DecodeAll(channel, outputBuffer, static_cast<size_t>(outputBufferSize));
}
