﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//! @brief  Hid の入力を扱います
class HidPad
{
public:
    enum Button
    {
        Button_A,
        Button_B,
        Button_X,
        Button_Y,
        Button_R,
        Button_L,
        Button_Z,
        Button_Start,
        Button_Left,
        Button_Up,
        Button_Right,
        Button_Down,

        Button_Max,
    };

public:
    //! @brief  初期化します
    void Initialize() NN_NOEXCEPT;
    //! @brief  更新処理をします
    void Update() NN_NOEXCEPT;

    //! @brief  ボタンを押しているかを返します
    bool IsHold(Button button) const NN_NOEXCEPT;
    //! @brief  ボタンを長押ししているときに適度に true を返します
    bool IsContinue(Button button) const NN_NOEXCEPT;
    //! @brief  ボタンを押した瞬間かを返します
    bool IsTrigger(Button button) const NN_NOEXCEPT;

    //! @brief  いずれかのボタンを押しているかを返します
    bool IsHoldAnyKey() const NN_NOEXCEPT;
    //! @brief  いずれかのボタンの IsContinue() が true であるかを返します
    bool IsContinueAnyKey() const NN_NOEXCEPT;
    //! @brief  いずれかのボタンを押した瞬間かを返します
    bool IsTriggerAnyKey() const NN_NOEXCEPT;

private:
    //  ボタンを押し続けているフレーム数
    int64_t m_HoldingFrameCount[Button_Max];
};
