﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/mem/mem_StandardAllocator.h>
#include <nn/htcs.h>
#include "ConnectionUtil.h"

namespace
{
    //  アロケータ
    nn::mem::StandardAllocator g_StandardAllocator;

    //  メモリを確保します
    void* Allocate(std::size_t size) NN_NOEXCEPT
    {
        return g_StandardAllocator.Allocate( size );
    }
    //  メモリを解放します
    void Free(void* pMemory, std::size_t size) NN_NOEXCEPT
    {
        NN_UNUSED( size );
        g_StandardAllocator.Free( pMemory );
    }
}

//  nn::fs, nn::htcs を初期化します
void InitializeConnectionUtil(void* buffer, size_t bufferSize) NN_NOEXCEPT
{
    g_StandardAllocator.Initialize( buffer, bufferSize );

    //  nn::fs にマウントします
    nn::Result result = nn::fs::MountHostRoot();
    NN_ABORT_UNLESS_RESULT_SUCCESS( result );

    nn::htcs::Initialize( Allocate, Free );
}
//  nn::fs, nn::htcs を終了します
void FinalizeConnectionUtil() NN_NOEXCEPT
{
    nn::htcs::Finalize();

    //  nn::fs からアンマウントします
    nn::fs::UnmountHostRoot();
}
