﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/vfx/vfx_Misc.h>
#include <nn/vfx/vfx_MemUtil.h>
#include <nn/vfx/vfx_VertexBuffer.h>

namespace nn {
namespace vfx {
namespace detail {


//---------------------------------------------------------------------------
//! @brief  コンストラクタ
//---------------------------------------------------------------------------
Attribute::Attribute() NN_NOEXCEPT
{
    m_BufferAddr[BufferSide_FrontBuffer]    = NULL;
    m_BufferAddr[BufferSide_BackBuffer]     = NULL;
}

//------------------------------------------------------------------------------
//  初期化
//------------------------------------------------------------------------------
bool Attribute::Initialize( nn::vfx::detail::BufferAllocator* bufferAllocator, int blockCount, size_t blockSize ) NN_NOEXCEPT
{
    m_BlockSize     = nn::util::align_up( blockSize, bufferAllocator->GetBufferAlign() );
    m_BlockCount    = blockCount;

    if ( !DynamicAllocateBuffer::Initialize( bufferAllocator, m_BlockSize * m_BlockCount ) )
    {
        return false;
    }

    Begin();
    {
        m_BufferAddr[BufferSide_FrontBuffer] = Cut( m_BlockSize );
        bufferAllocator->GetGpuAddress( &m_GpuAddress[BufferSide_FrontBuffer], m_BufferAddr[BufferSide_FrontBuffer]  );
        m_BufferAddr[BufferSide_BackBuffer] = Cut( m_BlockSize );
        bufferAllocator->GetGpuAddress( &m_GpuAddress[BufferSide_BackBuffer], m_BufferAddr[BufferSide_BackBuffer] );
        if( m_BlockCount == 3 )
        {
            m_BufferAddr[ BufferSide_TripleBuffer ] = Cut( m_BlockSize );
            bufferAllocator->GetGpuAddress( &m_GpuAddress[ BufferSide_TripleBuffer ], m_BufferAddr[ BufferSide_TripleBuffer ] );
        }
    }
    End();

    return true;
}

//---------------------------------------------------------------------------
//  終了処理
//---------------------------------------------------------------------------
void Attribute::Finalize() NN_NOEXCEPT
{
    DynamicAllocateBuffer::Finalize();
}

//---------------------------------------------------------------------------
//  指定サイドのバッファを取得します。
//---------------------------------------------------------------------------
void* Attribute::Map( BufferSide side ) NN_NOEXCEPT
{
    return m_BufferAddr[side];
}

//------------------------------------------------------------------------------
//  指定サイドのバッファを有効化します。
//------------------------------------------------------------------------------
void Attribute::Unmap() NN_NOEXCEPT
{
    return;
}

//---------------------------------------------------------------------------
//  Gpuアドレスを取得します。
//---------------------------------------------------------------------------
const nn::gfx::GpuAddress& Attribute::GetGpuAddress( BufferSide side ) const
{
    return m_GpuAddress[ side ];
}


} // namespace detail
} // namespace vfx
} // namespace nn
