﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ui2d/ui2d_TouchOffButton.h>

namespace nn
{
namespace ui2d
{

bool TouchOffButton::ProcessOff()
{
    const State currentState = GetState();
    switch (currentState) {
    case State_OffIdle:
        return true;
    case State_On:
        ChangeState(State_Off);
        StartOff();
        return true;
    case State_Off:
        return true;
    case State_OnIdle:
        ChangeState(State_Off);
        StartOff();
        return true;
    case State_Down:
        // DOWN中のoffは無視する(DOWNが終わるとoff状態に移行するのでoffする必要がない)
        return true;
    case State_DownIdle:
        return true;
    case State_Cancel:
        return true;
    default:
        NN_SDK_ASSERT(false, "Unknown State.");
        return true;
    };
}

bool TouchOffButton::ProcessOn()
{
    const State currentState = GetState();
    switch (currentState) {
    case State_OffIdle:
        ChangeState(State_On);
        StartOn();
        return true;
    case State_On:
        return true;
    case State_Off:
        ChangeState(State_On);
        StartOn();
        return true;
    case State_OnIdle:
        return true;
    case State_Down:
        // DOWN中のonは保持する(down中にもう一度押されたときに、down終了後にon状態になるため)
        return false;
    case State_DownIdle:
        // DOWN中のonが保持されていたらonに移行
        ChangeState(State_On);
        StartOn();
        return true;
    case State_Cancel:
        return false;
    default:
        NN_SDK_ASSERT(false, "Unknown State.");
        return true;
    };
}

void TouchOffButton::FinishDown()
{
    // 互換性のために、いったんSTATE_DOWN_IDLEにしてからSTATE_OFF_IDLEにします。
    ChangeState(State_DownIdle);
    // NormalButtonのようにON_IDLEに移るのではなく、OFF_IDLEに移る
    ChangeState(State_OffIdle);
}

} // namespace nn::ui2d
} // namespace nn
