﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ui2d/ui2d_DecisionButton.h>

namespace nn
{
namespace ui2d
{

bool DecisionButton::ProcessOn()
{
    // DOWN状態でアクションを受け付けないように修正します。
    const State currentState = GetState();
    switch (currentState) {
    case State_OffIdle:
        ChangeState(State_On);
        StartOn();
        return true;
    case State_On:
        return true;
    case State_Off:
        ChangeState(State_On);
        StartOn();
        return true;
    case State_OnIdle:
        return true;
    case State_Down:
        return true;
    case State_DownIdle:
        return true;
    case State_Cancel:
        return false;
    default:
        NN_SDK_ASSERT(false, "Unknown State.");
        return true;
    };
}

bool DecisionButton::ProcessOff()
{
    // DOWN状態でアクションを受け付けないように修正します。
    const State currentState = GetState();
    switch (currentState) {
    case State_OffIdle:
        return true;
    case State_On:
        ChangeState(State_Off);
        StartOff();
        return true;
    case State_Off:
        return true;
    case State_OnIdle:
        ChangeState(State_Off);
        StartOff();
        return true;
    case State_Down:
        return true;
    case State_DownIdle:
        return true;
    case State_Cancel:
        return true;
    default:
        NN_SDK_ASSERT(false, "Unknown State.");
        return true;
    };
}

} // namespace nn::ui2d
} // namespace nn
