﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ui2d/ui2d_Bounding.h>
#include <nn/ui2d/ui2d_DrawInfo.h>
#include <nn/ui2d/ui2d_GraphicsResource.h>
#include <nn/ui2d/ui2d_ResourceAccessor.h>
#include <nn/ui2d/ui2d_Resources.h>

namespace nn
{
namespace ui2d
{

Bounding::Bounding(
    const ResBounding* pBaseBlock,
    const ResBounding* pOverrideBlock,
    const BuildArgSet& buildArgSet
)
: Base(NULL, NULL, pBaseBlock, buildArgSet)
{
    NN_UNUSED(pOverrideBlock);
}

Bounding::Bounding(const Bounding& bounding)
: Base(bounding)
{
}

Bounding::~Bounding()
{
    // OSReport("Bounding::~Bounding()\n");
}

void
Bounding::DrawSelf(DrawInfo& drawInfo, nn::gfx::CommandBuffer& commandBuffer)
{
    NN_UNUSED(drawInfo);
    NN_UNUSED(commandBuffer);
}

bool
Bounding::CompareCopiedInstanceTest(const Bounding& target) const
{
    NN_UNUSED(target);
    // コピーコンストラクタで何もコピーしていないため比較するものはない。
    return true;
}

} // namespace nn::ui2d
} // namespace nn
