﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "precompiled.h"

#ifdef NN_BUILD_CONFIG_SPY_ENABLED

#include <nn/diag/text/diag_SdkTextSpy.h>

#include <nn/spy/detail/fnd/string/spyfnd_String.h>
#include <nn/spy/spy_PlotFloat.h>

namespace nn {
namespace spy {

//------------------------------------------------------------------------------
PlotFloat::PlotFloat() NN_NOEXCEPT
{
    InitializePacketCommonData();
}

//------------------------------------------------------------------------------
PlotFloat::PlotFloat(const char* name) NN_NOEXCEPT
{
    InitializePacketCommonData();
    SetName(name);
}

//------------------------------------------------------------------------------
PlotFloat::PlotFloat(const char* name, double minValue, double maxValue, uint8_t r, uint8_t g, uint8_t b) NN_NOEXCEPT
{
    InitializePacketCommonData();
    SetName(name);
    SetRange(minValue, maxValue);
    SetColor(r, g, b);
}

//------------------------------------------------------------------------------
PlotFloat::~PlotFloat() NN_NOEXCEPT
{
}

//------------------------------------------------------------------------------
void PlotFloat::SetRange(double minValue, double maxValue) NN_NOEXCEPT
{
    if(IsRequested())
    {
        NN_DETAIL_SPY_WARN(NN_TEXT_SPY("[%s] 通信中は、SpyPlotItem の範囲を変更できません。\n"), NN_CURRENT_FUNCTION_NAME);
        return;
    }

    m_MetadataPacketPayload.minValue.Set(minValue);
    m_MetadataPacketPayload.maxValue.Set(maxValue);
}

//------------------------------------------------------------------------------
void PlotFloat::SetInterpolationMode(InterpolationMode mode) NN_NOEXCEPT
{
    if(IsRequested())
    {
        NN_DETAIL_SPY_WARN(NN_TEXT_SPY("[%s] 通信中は、SpyPlotItem の補間モードを変更できません。\n"), NN_CURRENT_FUNCTION_NAME);
        return;
    }

    m_MetadataPacketPayload.interpolationMode = static_cast<uint8_t>(mode);
}

//------------------------------------------------------------------------------
void PlotFloat::PushValue(double value) NN_NOEXCEPT
{
    if(!IsRequested())
    {
        return;
    }

    PushValueAt(value, nn::os::GetSystemTick());
}

//------------------------------------------------------------------------------
void PlotFloat::PushValueAt(double value, nn::os::Tick tick) NN_NOEXCEPT
{
    if(!IsRequested())
    {
        return;
    }

#if defined(NN_DETAIL_ENABLE_SDK_ASSERT)
    CheckTick(tick);
#endif

    // メタデータをプッシュしていない場合は先にプッシュする
    if(!IsMetadataPushed())
    {
        PushMetaData();
    }

    m_ValuePacketPayload.value.Set(value);

    PushDataAt(m_ValuePacketPayload, tick);
}

//------------------------------------------------------------------------------
void PlotFloat::InitializePacketCommonData() NN_NOEXCEPT
{
    std::memset(&m_MetadataPacketPayload, 0, sizeof(m_MetadataPacketPayload));
    InitializeItemMetaData(&m_MetadataPacketPayload.itemMetaData);
    m_MetadataPacketPayload.common.dataType = nn::spy::detail::SpyPlotItemPacket::DataType_FloatMetadata;
    m_MetadataPacketPayload.minValue.Set(0);
    m_MetadataPacketPayload.maxValue.Set(1);
    m_MetadataPacketPayload.interpolationMode = static_cast<uint8_t>(InterpolationMode_None);

    std::memset(&m_ValuePacketPayload, 0, sizeof(m_ValuePacketPayload));
    m_ValuePacketPayload.common.dataType = nn::spy::detail::SpyPlotItemPacket::DataType_FloatValue;
    m_ValuePacketPayload.id = m_MetadataPacketPayload.itemMetaData.id;
}

//------------------------------------------------------------------------------
void PlotFloat::PushOwnMetaData() NN_NOEXCEPT
{
    if(!PushData(m_MetadataPacketPayload))
    {
        NN_DETAIL_SPY_WARN(NN_TEXT_SPY("[%s] PlotFloat '%s' のメタデータ送信に失敗しました。\n"), NN_CURRENT_FUNCTION_NAME, GetName());
    }
}

} // namespace nn::spy
} // namespace nn

#endif // NN_BUILD_CONFIG_SPY_ENABLED
