﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "precompiled.h"

#include <nn/diag/text/diag_SdkTextSpy.h>

#include <nn/spy/detail/fnd/string/spyfnd_String.h>
#include <nn/spy/spy_MarkerModule.h>
#include <nn/spy/spy_SpyController.h>

namespace nn {
namespace spy {

NN_DEFINE_STATIC_CONSTANT(const int Marker::MaxDescriptionLength);

#ifdef NN_BUILD_CONFIG_SPY_ENABLED

//----------------------------------------------------------
MarkerModule::MarkerModule() NN_NOEXCEPT
    : SpyModule("Marker", nn::spy::detail::MarkerPacket::PacketVersion)
    , m_pMarkerTop(NULL)
    , m_pMarkerLast(NULL)
{
}

//----------------------------------------------------------
bool MarkerModule::AttachMarker(Marker& marker) NN_NOEXCEPT
{
    if(marker.IsAttached())
    {
        if (marker.GetModule() != this)
        {
            NN_DETAIL_SPY_WARN(NN_TEXT_SPY("[%s] Marker は、複数の MarkerModule にアタッチできません。\n"), NN_CURRENT_FUNCTION_NAME);
            return false;
        }

        return true;
    }

    if(m_pMarkerTop == NULL)
    {
        m_pMarkerTop = &marker;
        m_pMarkerLast = &marker;
    }
    else
    {
        NN_SDK_ASSERT(m_pMarkerLast != NULL);
        m_pMarkerLast->SetNext(&marker);
        marker.SetPrevious(m_pMarkerLast);
        m_pMarkerLast = &marker;
    }

    marker.Attach(*this);

    return true;
}

//----------------------------------------------------------
void MarkerModule::DetachMarker(Marker& marker) NN_NOEXCEPT
{
    // Previous -> Next をつなぐ
    // Top を更新する
    if(marker.GetPrevious() != NULL)
    {
        marker.GetPrevious()->SetNext(marker.GetNext());
    }
    else
    {
        NN_SDK_ASSERT(m_pMarkerTop == &marker);
        m_pMarkerTop = marker.GetNext();
    }

    // Previous <- Next をつなぐ
    // Last を更新する
    if(marker.GetNext() != NULL)
    {
        marker.GetNext()->SetPrevious(marker.GetPrevious());
    }
    else
    {
        NN_SDK_ASSERT(m_pMarkerLast == &marker);
        m_pMarkerLast = marker.GetPrevious();
    }

    marker.Detach();
}

//------------------------------------------------------------------------------
Marker::Marker() NN_NOEXCEPT
    : m_pModule(NULL)
    , m_pPrevious(NULL)
    , m_pNext(NULL)
{
    InitializePacketCommonData();
}

//------------------------------------------------------------------------------
Marker::~Marker() NN_NOEXCEPT
{
    if(IsAttached())
    {
        m_pModule->DetachMarker(*this);
    }
}

//------------------------------------------------------------------------------
void Marker::PushValue(const char* description, uint8_t r, uint8_t g, uint8_t b) NN_NOEXCEPT
{
    if(!IsRequested()) { return; }

    m_ValuePacketPayload.color.r = r;
    m_ValuePacketPayload.color.g = g;
    m_ValuePacketPayload.color.b = b;
    m_ValuePacketPayload.color.a = 0xFF;
    m_ValuePacketPayload.description.Set(description);

    m_pModule->PushData(&m_ValuePacketPayload, sizeof(nn::spy::detail::MarkerPacket::ValuePacketPayload));
}

//------------------------------------------------------------------------------
void Marker::InitializePacketCommonData() NN_NOEXCEPT
{
    m_ValuePacketPayload.id.Set(this);
}

//------------------------------------------------------------------------------
void Marker::Attach(MarkerModule& module) NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_pModule == NULL || m_pModule == &module, NN_TEXT_SPY("この Marker は、すでに他の MarkerModule にアタッチされています。"));

    m_pModule = &module;
}

//------------------------------------------------------------------------------
void Marker::Detach() NN_NOEXCEPT
{
    m_pModule = NULL;
    SetPrevious(NULL);
    SetNext(NULL);
}

#endif // NN_BUILD_CONFIG_SPY_ENABLED

} // namespace nn::spy
} // namespace nn
