﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "precompiled.h"

#include <nn/spy/detail/fnd/basis/spyfnd_Time.h>
#include <nn/spy/detail/fnd/binary/spyfnd_Binary.h>
#include <nn/spy/detail/fnd/string/spyfnd_String.h>
#include <nn/spy/detail/spy_SpyDataId.h>
#include <nn/spy/spy_LogModule.h>
#include <nn/spy/spy_SpyController.h>

namespace nn {
namespace spy {

NN_DEFINE_STATIC_CONSTANT(const int LogModule::MaxMessageLength);

#ifdef NN_BUILD_CONFIG_SPY_ENABLED

namespace {

//! @briefprivate
struct LogPacketData
{
    static const uint32_t Version = NN_DETAIL_SPY_FND_BINARY_MAKE_U32_SIGNATURE(0, 2, 0, 0);

    char message[nn::spy::LogModule::MaxMessageLength + 1];
};

} // namespace

//----------------------------------------------------------
LogModule::LogModule() NN_NOEXCEPT
    : SpyModule("Log", LogPacketData::Version)
{
}

//----------------------------------------------------------
bool
LogModule::Write(SpyController& controller, const char* message) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(message);

    LogPacketData packet;

    nn::spy::detail::fnd::String::Copy(packet.message, sizeof(packet.message), message);

    return controller.GetLogModule().PushData(&packet, sizeof(packet));
}

//----------------------------------------------------------
bool
LogModule::WriteFormatV(SpyController& controller, const char* format, va_list argList) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(format);

    LogPacketData packet;

    nn::spy::detail::fnd::String::Vsnprintf(packet.message, sizeof(packet.message), format, argList);

    return controller.GetLogModule().PushData(&packet, sizeof(packet));
}

//----------------------------------------------------------
bool
LogModule::WriteFormatImpl(SpyController& controller, const char* format, ...) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(format);

    va_list argList;
    va_start(argList, format);

    bool result = WriteFormatV(controller, format, argList);

    va_end(argList);

    return result;
}

//----------------------------------------------------------
bool
LogModule::WriteFormatImpl(const char* format, ...) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(format);

    if(!IsRegistered())
    {
        return false;
    }

    va_list argList;
    va_start(argList, format);
    bool result = LogModule::WriteFormatV(*GetController(), format, argList);
    va_end(argList);

    return result;
}

#endif // NN_BUILD_CONFIG_SPY_ENABLED

} // namespace nn::spy
} // namespace nn
