﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "precompiled.h"

#include <nn/spy/detail/spy_SpyDataId.h>
#include <nn/spy/spy_DebugModule.h>
#include <nn/spy/spy_SpyController.h>

namespace nn {
namespace spy {

#ifdef NN_BUILD_CONFIG_SPY_ENABLED

DebugModule::DebugModule() NN_NOEXCEPT
    : SpyModule("Debug", NN_DETAIL_SPY_FND_BINARY_MAKE_U32_SIGNATURE(0, 0, 0, 1))
    , m_DataBufferLength("@nn/spy/DataBufferLength")
    , m_DataBufferUsage("@nn/spy/DataBufferUsage")
    , m_IsDataBufferLengthSent(true)
{
}

void DebugModule::OnRegistered() NN_NOEXCEPT
{
    Base::OnRegistered();

    GetController()->GetPlotModule().AttachItem(m_DataBufferUsage);
    GetController()->GetPlotModule().AttachItem(m_DataBufferLength);
}

void DebugModule::OnUnregistered() NN_NOEXCEPT
{
    GetController()->GetPlotModule().DetachItem(m_DataBufferUsage);
    GetController()->GetPlotModule().DetachItem(m_DataBufferLength);

    Base::OnUnregistered();
}

void DebugModule::OnSessionStarted() NN_NOEXCEPT
{
    Base::OnSessionStarted();
    m_IsDataBufferLengthSent = false;
}

bool DebugModule::PushDataBufferUsage() NN_NOEXCEPT
{
    if (!GetController()->GetPlotModule().IsRequested())
    {
        return false;
    }

    if (!m_IsDataBufferLengthSent)
    {
        m_IsDataBufferLengthSent = true;
        PushDataBufferLength();
    }

    m_DataBufferUsage.PushValue(static_cast<double>(GetController()->GetDataBufferUsageMax()));

    return true;
}

void DebugModule::PushDataBufferLength() NN_NOEXCEPT
{
    m_DataBufferLength.PushValue(static_cast<double>(GetController()->GetCurrentDataBuffer().length));
}

#endif // NN_BUILD_CONFIG_SPY_ENABLED

} // namespace nn::spy
} // namespace nn
