﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../../precompiled.h"

#ifdef NN_BUILD_CONFIG_SPY_ENABLED

#include <nn/spy/detail/fnd/hio/spyfnd_HioInitializer.h>

#include <WinSock2.h>

namespace nn {
namespace spy {
namespace detail {
namespace fnd {

//----------------------------------------------------------

int HioInitializer::m_Count = 0;

//----------------------------------------------------------
void
HioInitializer::Initialize() NN_NOEXCEPT
{
    ++m_Count;

    if(m_Count > 1)
    {
        return;
    }

    WSADATA wsaData;
    WSAStartup(MAKEWORD(2,0), &wsaData);
}

//----------------------------------------------------------
void
HioInitializer::Finalize() NN_NOEXCEPT
{
    if(m_Count == 0)
    {
        return;
    }

    --m_Count;

    if(m_Count == 0)
    {
        WSACleanup();
    }
}

} // namespace nn::spy::detail::fnd
} // namespace nn::spy::detail
} // namespace nn::spy
} // namespace nn

#endif // NN_BUILD_CONFIG_SPY_ENABLED
